/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QLineEdit>
#include <QTextBrowser>
#include <QCloseEvent>
#include <QToolButton>
//-----------------------------------------------------------------------------
#include "helpwindow.h"
extern QString pathHelp;
//-----------------------------------------------------------------------------
HelpWindow::HelpWindow(QWidget *parent) : QMdiSubWindow(parent)
{
	QPushButton *b;
	QToolButton *t;
	QWidget *p = new QWidget(this);
	QVBoxLayout *o = new QVBoxLayout(p);
	QHBoxLayout *a = new QHBoxLayout();	o->addLayout(a);
	help = new QTextBrowser(this);	o->addWidget(help);
	setPath(pathHelp);	help->setSource(tr("script_mgl_eng.html"));

	b = new QPushButton(QPixmap(":/xpm/go-previous.png"), tr("Backward"), p);
	connect(b, SIGNAL(clicked()), help, SLOT(backward()));	a->addWidget(b);
	entry = new QLineEdit(p);	a->addWidget(entry);
	connect(entry, SIGNAL(textChanged(const QString &)), this, SLOT(showHelp(const QString &)));
	connect(entry, SIGNAL(returnPressed()), this, SLOT(showHelp()));
	b = new QPushButton(QPixmap(":/xpm/go-next.png"), tr("Forward"), p);
	connect(b, SIGNAL(clicked()), help, SLOT(forward()));	a->addWidget(b);
	b = new QPushButton(QPixmap(":/xpm/help-faq.png"), tr("&Examples"), this);
	connect(b, SIGNAL(clicked()), this, SLOT(showExamples()));	a->addWidget(b);
	t = new QToolButton(p);	t->setIcon(QPixmap(":/xpm/zoom-in.png"));
	connect(t, SIGNAL(clicked()), this, SLOT(zoomIn()));	a->addWidget(t);
	t = new QToolButton(p);	t->setIcon(QPixmap(":/xpm/zoom-out.png"));
	connect(t, SIGNAL(clicked()), this, SLOT(zoomOut()));	a->addWidget(t);
	setWidget(p);	setWindowTitle(tr("Help"));
}
//-----------------------------------------------------------------------------
HelpWindow::~HelpWindow()	{}
//-----------------------------------------------------------------------------
void HelpWindow::setPath(const QString &path)
{	QStringList s;	s<<path;	help->setSearchPaths(s);	}
//-----------------------------------------------------------------------------
void HelpWindow::closeEvent(QCloseEvent* ce)	{	ce->ignore();	}
//-----------------------------------------------------------------------------
void HelpWindow::showExamples()
{
	setWindowTitle("Examples");	showMaximized();	raise();
	help->setSource(tr("example_mgl_eng.html"));
}
//-----------------------------------------------------------------------------
void HelpWindow::showHelp(const QString &txt)
{
	QString cmd=txt;
	showMaximized();	raise();
	if(cmd.isEmpty())	cmd = entry->text().trimmed();
	if(cmd.isEmpty())	help->setSource(tr("script_mgl_eng.html"));
	else	help->setSource(tr("script_mgl_eng.html")+"#"+cmd);
	setWindowTitle("Help");
}
//-----------------------------------------------------------------------------
void HelpWindow::zoomIn()
{
	QFont f(help->font());	f.setPointSize(f.pointSize()+1);	help->setFont(f);
}
//-----------------------------------------------------------------------------
void HelpWindow::zoomOut()
{
	QFont f(help->font());	f.setPointSize(f.pointSize()-1);	help->setFont(f);
}
//-----------------------------------------------------------------------------
