#!/usr/bin/env python
# setup.py - Build system for Ubuntu One Control Panel package
#
# Author: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Setup.py: build, distribute, clean."""

import sys

try:
    import DistUtilsExtra.auto
except ImportError:
    print >> sys.stderr, 'To build this program you need '\
                         'https://launchpad.net/python-distutils-extra'
    sys.exit(1)

DistUtilsExtra.auto.setup(
    name='ubuntuone-file-storage-api',
    version='0.0.2',
    license='GPL-3',
    author='Natalia Bidart',
    author_email='natalia.bidart@canonical.com',
    description='Ubuntu One File Storage APIs',
    long_description='A set of sync and async wrappers to the REST api\'s '
        'described in: https://wiki.canonical.com/UbuntuOne/RESTfulStorage.',
    url='https://launchpad.net/ubuntuone-file-storage-api',
    packages=['ubuntuone.filestorageapi'],
    extra_path='ubuntuone-file-storage-api',
)
