# Author: Manuel de la Pena manuel@canonical.com
#
# Copyright 2010-2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""The Qt main loop integration reactor for testing."""

import sys

REACTOR_URL = 'https://github.com/ghtdak/qtreactor'


def install(options=None):
    """Install the reactor and parse any options we might need."""
    if options is not None and options.use_gui:
        from PyQt4.QtGui import QApplication
        # We must assign this to a variable, or we will get crashes in Qt
        # pylint: disable=W0612
        app = QApplication(sys.argv)
        # pylint: enable=W0612

    qt4reactor = __import__('qtreactor.qt4reactor', None, None, [''])
    qt4reactor.install()
