#!/usr/bin/env python
#
# Copyright 2010 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License version 3,
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""setup.py"""

import subprocess
import sys

from distutils.core import setup, Command

PACKAGE = 'ubuntuone-dev-tools'
VERSION = '0.1.3'

U1LINT = 'bin/u1lint'


class Lint(Command):
    """Command to run the lint checks."""
    description = 'run python lint checks'

    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        """Run u1lint to check the code."""
        retcode = subprocess.call([U1LINT])
        if retcode != 0:
            sys.exit(retcode)

setup(name=PACKAGE,
      version=VERSION,
      description='Ubuntu One development tools and utilities',
      url='http://launchpad.net/ubuntuone-dev-tools',
      packages=['ubuntuone',
                'ubuntuone.devtools',
                'ubuntuone.devtools.services'],
      extra_path='ubuntuone-dev-tools',
      scripts=['bin/u1lint',
               'bin/u1trial',
               ],
      data_files=[('share/%s' % PACKAGE,
                   ['pylintrc',
                    'data/dbus-session.conf.in']),
                  ('share/man/man1',
                   ['man/u1lint.1',
                    'man/u1trial.1']),
                  ],

      cmdclass={
        'lint': Lint,
        },
      )
