#!/usr/bin/env python
# 
# 2010-02-08
# Approve an applicant's membership in the Ubuntu Bug Squad team

from launchpadlib.launchpad import Launchpad, EDGE_SERVICE_ROOT
from launchpadlib.errors import HTTPError
from launchpadlib.credentials import Credentials
from datetime import date

import os, sys

cachedir = os.path.expanduser("~/.launchpadlib/cache/")

if not os.path.exists(cachedir):
    os.makedirs(cachedir,0700)

script_name = sys.argv[0].split("/")[-1].split('.')[0]

credfile = os.path.expanduser('~/.launchpadlib/%s.cred' % script_name)

try:
    credentials = Credentials()
    credentials.load(open(credfile))
    launchpad = Launchpad(credentials, EDGE_SERVICE_ROOT, cachedir)
except:
    launchpad = Launchpad.get_token_and_login(script_name, EDGE_SERVICE_ROOT, cachedir)
    launchpad.credentials.save(open(credfile,"w",0600)) 
    
welcome = "Thanks for helping to make Ubuntu even better and welcome to the team!" 

lpid = sys.argv[1]

try:
    person = launchpad.people['%s' % lpid]
except HTTPError, error:
    print "Could not find person %s" % lpid

team = launchpad.people['bugsquad']

today = date.today()

future = today.replace(year = today.year + 1)

expiration_date = future.strftime("%Y-%m-%d")

if person.is_ubuntu_coc_signer:
    # 2010-04-05 - member_detail is 404'ing now for non-proposed members?
    try:
        member_detail = launchpad.load(str(launchpad._root_uri) + '~bugsquad/+member/%s' % lpid)
        # this handles people who have attempted to join the team
        if member_detail.status == 'Proposed':
            # approving a member will use the default expiration date set for the team which is good
            try:
                team.addMember(person=person, status='Approved', comment=welcome)
            except HTTPError, error:
                print state, error.content
        elif member_detail.status == 'Approved':
            try:
                member_detail.setExpirationDate(date=expiration_date)
            except HTTPError, error:
                print state, error.content
    # this will handle people who have not attempted to join the team
    except HTTPError, error:
        if error.response['status'] == '404':
            try:
                team.addMember(person=person, status='Approved', comment=welcome)
            except HTTPError, error:
                print state, error.content
else:
    print "%s: %s has not signed the CoC" % ( lpid, person.display_name )
