//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify  *
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <assert.h>
#include "LoopSelection.h"

BOOLEANPLUGIN(LoopSelection,"Loop Selection","David Auber","20/01/2003","Alpha","1.0");

using namespace std;
using namespace tlp;

LoopSelection::LoopSelection(const PropertyContext &context):BooleanAlgorithm(context) {}
//============================================
bool LoopSelection::run() {
  booleanResult->setAllNodeValue(false);
  edge e;
  forEach(e, graph->getEdges())
    booleanResult->setEdgeValue(e, 
			       graph->source(e)==graph->target(e));
  return true;
}
//============================================

