/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#include "font.inc"

#ifdef HAVE_SDL

static char bits[]={1,2,4,8,16,32,64,128};

void fontoutc(SDL_Surface *surface, int x, int y, int color, int bgcolor, int flags, unsigned char c){
    int i, j;
    char *fc;

	fc=font_vga+ ((unsigned char)c)*16;
	for (i=0; i<16; i++){
		for (j=7; j>=0; j--){
		   if (*fc & bits[7-j])
			   fast_putpixel(surface, x+j, y+i, color);
		   else
			   if (!(flags & FONT_TRANSP)) fast_putpixel(surface, x+j, y+i, bgcolor);
		}
        if (((c&0xf0)==0x90 || c==134 ) && (*fc & bits[0])){
			fast_putpixel(surface, x+8, y+i, color);
        }else{
    		if (!(flags & FONT_TRANSP)) fast_putpixel(surface, x+8, y+i, bgcolor);
        }
		fc++;
		
	}
}

void fontout(SDL_Surface *surface, int x, int y, int color, int flags, char *s){
    int i, j, xx;
    char *c, *fc;

    if (flags & FONT_CENTER){
        x-=(strlen(s)*9/2);
        y-=8;
    }
    
    if (flags & FONT_RIGHT){
        x-=strlen(s)*9;
    }

    
    xx=x;

/*    dbg("xx=%d y=%d\n", xx,y);*/
    for (c=s; *c!='\0';c++){
        fc=font_vga+ ((unsigned char)*c)*16;
        for (i=0; i<16; i++){
            for (j=7; j>=0; j--){
               if (*fc & bits[7-j])
                   fast_putpixel(surface, x+j, y+i, color);
               else
                   if (!(flags & FONT_TRANSP)) fast_putpixel(surface, x+j, y+i, 0);
            }
            if (!(flags & FONT_TRANSP)) fast_putpixel(surface, x+8, y+i, 0);
            fc++;
            
        }
        x+=9;
    }
    if (flags&FONT_SYNC){
       /* rect(ggfx->scr, xx, y, xx+strlen(s)*9, y+16,  0xff00);*/
        SDL_UpdateRect(surface, xx, y, strlen(s)*9, 16);
/*        SDL_UpdateRect(ggfx->screen, 0,0,0,0);*/
    }
}

void fontoutf(SDL_Surface *surface, int x, int y, int color, int flags, char *m, ...) 
{
    va_list l;
    gchar *c;

    if (!cfg) return;
    va_start(l, m);
    c=g_strdup_vprintf(m, l);
    va_end(l);
    
    fontout(surface, x, y, color, flags, c);

    g_free(c);
}


int fontwidth(char *text){
	return strlen(text)*9;
}

int fontheight(char *text){
	return 8;
}

#endif
