<?cs include "header.cs"?>
<?cs include "macros.cs"?>

<div id="ctxtnav" class="nav"></div>

<div id="content" class="roadmap">
 <h1>ロードマップ</h1>

 <form id="prefs" method="get" action="">
  <div>
   <input type="checkbox" id="showall" name="show" value="all"<?cs
    if:roadmap.showall ?> checked="checked"<?cs /if ?> />
   <label for="showall">既に完了したマイルストーンも表示</label>
  </div>
  <div class="buttons">
   <input type="submit" value="更新" />
  </div>
 </form>

 <ul class="milestones"><?cs each:milestone = roadmap.milestones ?>
  <li class="milestone">
   <div class="info">
    <h2><a href="<?cs var:milestone.href ?>">マイルストーン: <em><?cs
      var:milestone.name ?></em></a></h2>
    <p class="date"<?cs
     if:milestone.completed_date ?> title="<?cs var:milestone.completed_date ?>">
      <?cs var:milestone.completed_delta ?> 前に完了<?cs
     elif:milestone.due_date ?> title="<?cs var:milestone.due_date ?>"><?cs
      if:milestone.late ?>
       <strong>完了期限から <?cs var:milestone.due_delta ?> 遅れ</strong><?cs
      else ?>
       あと <?cs var:milestone.due_delta ?> で完了期限<?cs
      /if ?> (<?cs var:milestone.due_date ?>)<?cs
     else ?>>
      完了期限が設定されていません<?cs
     /if ?>
    </p><?cs
    with:stats = milestone.stats ?><?cs
     if:#stats.total_tickets > #0 ?>
      <table class="progress">
       <tr>
        <td class="closed" style="width: <?cs
          var:#stats.percent_closed ?>%"><a href="<?cs
          var:milestone.queries.closed_tickets ?>" title="<?cs
          var:#stats.total_tickets ?> 個中 <?cs
          var:#stats.closed_tickets ?> 個のチケットが解決済み"></a></td>
        <td class="open" style="width: <?cs
          var:#stats.percent_active ?>%"><a href="<?cs
          var:milestone.queries.active_tickets ?>" title="<?cs
          var:#stats.total_tickets ?> 個中 <?cs
          var:#stats.active_tickets ?> 個のチケットが未解決"></a></td>
       </tr>
      </table>
      <p class="percent"><?cs var:#stats.percent_closed ?>%</p>
      <dl>
       <dt>解決済みのチケット:</dt>
       <dd><a href="<?cs var:milestone.queries.closed_tickets ?>"><?cs
         var:stats.closed_tickets ?></a></dd>
       <dt>未解決のチケット:</dt>
       <dd><a href="<?cs var:milestone.queries.active_tickets ?>"><?cs
         var:stats.active_tickets ?></a></dd>
      </dl><?cs
     /if ?><?cs
    /with ?>
   </div>
   <div class="description"><?cs var:milestone.description ?></div>
  </li><?cs
 /each ?></ul><?cs
 if:trac.acl.MILESTONE_CREATE ?>
  <div class="buttons">
   <form method="get" action="<?cs var:trac.href.milestone ?>"><div>
    <input type="hidden" name="action" value="new" />
    <input type="submit" value="マイルストーンの登録" />
   </div></form>
  </div><?cs
 /if ?>

 <div id="help">
  <strong>Note:</strong> ロードマップについてのヘルプは <a href="<?cs
    var:trac.href.wiki ?>/TracRoadmap">TracRoadmap</a> を参照してください。
 </div>

</div>
<?cs include:"footer.cs"?>
