# -*- coding: iso-8859-1 -*-
#
# Copyright (C) 2008 Jelmer Vernooij <jelmer@samba.org>
# All rights reserved.
#
# This software may be used and distributed according to the terms
# of the GNU General Public License, incorporated herein by reference.


import urllib

from bzrlib.tests import treeshape
from trac import versioncontrol

from tracbzr import tests

class TestRepository(tests.SingleBranchTracTestCase):

    def test_get_changeset(self):
        self.assertRaises(versioncontrol.NoSuchChangeset, 
                          self.trac_repo().get_changeset, 'foo')
        self.assertRaises(versioncontrol.NoSuchChangeset, 
                          self.trac_repo().get_changeset, ',foo')
        self.assertRaises(versioncontrol.NoSuchChangeset, 
                          self.trac_repo().get_changeset, '1')
        revision_id = self.commit_foo_bar()
        assert revision_id is not None
        changeset = self.trac_repo().get_changeset("1")
        revision_id = urllib.quote(revision_id, '')
        changeset = self.trac_repo().get_changeset(revision_id)

    def commit_foo_bar(self):
        """Create a simple revision"""
        treeshape.build_tree_contents([('repo/a/',), ('repo/a/b', 
                                        'contents of b')])
        self.tree.add(['a', 'a/b'])
        return self.tree.commit('tree contents', rev_id='foo%bar')
