import logging

import os

from trac import config
from bzrlib import bzrdir, tests

from tracbzr import backend


class DummyComponent(object):

    def __init__(self):
        self.log = logging.getLogger('tracbzr.tests')
        self.log.setLevel(logging.ERROR)
        self.config = config.Configuration(None)


class AbstractTracTestCase(tests.TestCaseInTempDir):

    def trac_repo(self, location="repo"):
        param = { 'name': location, 'id': 'trac_bzr_selftest' }
        return backend.BzrRepository(os.path.join(self.test_dir, "repo"), param, DummyComponent())


class MultiBranchTracTestCase(AbstractTracTestCase):

    def setUp(self):
        super(MultiBranchTracTestCase, self).setUp()
        dir = bzrdir.BzrDir.create(os.path.join(self.test_dir, "repo"))
        self.repo = dir.create_repository()
        self.treedir = os.path.join(self.test_dir, "repo", 'tree')
        self.branch = bzrdir.BzrDir.create_branch_convenience(self.treedir,
            force_new_tree=True)
        self.tree = self.branch.bzrdir.open_workingtree()


class SingleBranchTracTestCase(AbstractTracTestCase):

    def setUp(self):
        super(SingleBranchTracTestCase, self).setUp()
        branch = bzrdir.BzrDir.create_branch_convenience(
            os.path.join(self.test_dir, "repo"), force_new_tree=True)
        self.tree = branch.bzrdir.open_workingtree()
        self.repo = branch.repository
        self.treedir = os.path.join(self.test_dir, "repo")
