# Copyright (C) 2006 Panometrics, Inc.
# All rights reserved.
#
# This software may be used and distributed according to the terms
# of the GNU General Public License, incorporated herein by reference.

import urllib

from bzrlib import conflicts
from bzrlib.revision import (
    CURRENT_REVISION,
    )
from bzrlib.tests import treeshape

from tracbzr import tests

class TestNode(tests.MultiBranchTracTestCase):

    def commit_foo_bar_baz(self):
        """Create an interesting merge history"""
        treeshape.build_tree_contents([('repo/tree/a/',), ('repo/tree/a/b', 
                                        'contents of b')])
        self.tree.add(['a', 'a/b'])
        self.tree.commit('tree contents', rev_id='foo%bar') #tree,1
        other = self.tree.bzrdir.sprout('repo/other').open_workingtree()
        treeshape.build_tree_contents([
            ('repo/other/a/b', 'new contents of b'),
            ('repo/other/a/c', 'contents of c')])
        other.add(['a/c'])
        other.commit('added c, changed b', rev_id='baz') #other,1
        self.tree.merge_from_branch(other.branch)
        self.tree.commit('merged from other', rev_id='qux') #tree,2
        self.tree.commit('empty commit', rev_id='quxx') #tree,3
        treeshape.build_tree_contents([
            ('repo/tree/a/b', 'b_tree')])
        self.tree.commit('changed b', rev_id='quxxx') #tree,4
        treeshape.build_tree_contents([
            ('repo/other/a/b', 'new again')])
        other.commit('changed b') #other,2
        self.tree.merge_from_branch(other.branch)
        treeshape.build_tree_contents([
            ('repo/tree/a/b', 'b_tree')])
        self.tree.set_conflicts(conflicts.ConflictList([]))
        return self.tree.commit('resolved in favour of tree', rev_id='quxxxx') #tree,5
         
    def test_get_history(self):
        self.commit_foo_bar_baz()
        repo = self.trac_repo()
        node = repo.get_node('tree/a/b')
        self.assertEqual([(u'tree/a/b', 'tree,4', 'edit'),
                          (u'tree/a/b', 'tree,2', 'edit'),
                          (u'tree/a/b', 'tree,1', 'add')], 
                         list(node.get_history()))
        node = repo.get_node('')
        self.assertEqual([('', CURRENT_REVISION, 'add')], list(node.get_history()))

    def test_get_dir_history(self):
        self.commit_foo_bar_baz()
        repo = self.trac_repo()
        node = repo.get_node('tree/a')
        self.assertEqual([(u'tree/a', 'tree,4', 'edit'),
                          (u'tree/a', 'tree,2', 'edit'),
                          (u'tree/a', 'tree,1', 'add')], 
                         list(node.get_history()))

    def test_get_root_history(self):
        self.commit_foo_bar_baz()
        repo = self.trac_repo()
        node = repo.get_node('tree')
        self.assertEqual([(u'tree', 'tree,5', 'edit'),
                          (u'tree', 'tree,4', 'edit'),
                          (u'tree', 'tree,3', 'edit'),
                          (u'tree', 'tree,2', 'edit'),
                          (u'tree', 'tree,1', 'edit'),
                          (u'tree', 'tree,0', 'add')], 
                         list(node.get_history()))
