#include "tra.h"

static void copyfile(Syncpath*);
static void copytree(Syncpath*);
static int rm(Syncpath*);
static void work(Syncpath*);

static void
workthread0(void *a)
{
	Queue *q;

	q = a;
	startclient();
	for(;;)
		work(qrecv(q));
}

void
workthread(void *a)
{
	int i;
	Syncpath *s;
	Queue *q;
	Queue *subq;

	subq = mkqueue();
	for(i=0; i<32; i++)
		threadcreate(workthread0, subq);

//print("work dispatch %p\n", curthread);
	startclient();
	q = a;
	for(;;){
		s = qrecv(q);
		if(s->state==SyncCopy && s->f->state==SFile)
			qsend(subq, s);
		else
			work(s);
	}
}

static void
copy(Syncpath *s)
{
	switch(s->f->state){
	default:
		abort();
	case SDir:
		copytree(s);
		break;
	case SFile:
		copyfile(s);
		break;
	}
}

static int
copybytes(Replica *rr, int rfd, Replica *wr, int wfd, char *buf, vlong *roff, vlong off, vlong n)
{
	vlong tot;
	int m;

	if(*roff != off){
		if(rpcseek(rr, rfd, off) < 0)
			return -1;
		*roff = off;
	}
	for(tot=0; tot<n; tot+=m){
		if(n-tot > IOCHUNK)
			m = IOCHUNK;
		else
			m = n-tot;
//		fprint(2, "copybytes: tot=%lld n=%lld m=%d\n", tot, n, m);
		if((m = rpcread(rr, rfd, buf, m)) < 0
		|| rpcwrite(wr, wfd, buf, m) != m){
			*roff = -1;
			return -1;
		}
	}
	*roff += tot;
	return 0;
}

static void
copyfile(Syncpath *s)
{
	char *e;
	char *buf;
	int i, rfd, wfd, nh;
	vlong nc;
	Hash *h;
	Hashlist *hf, *ht;
//	Vtime *oldsynctime;
	vlong roff;

	/* 
	 * Setup for copy.
	 */
	if(s->t->state==SDir){
		/*
		 * TODO?:
		 * set sync time to 0 so that if we get interrupted,
		 * another sync will show a conflict rather than
		 * think we meant to delete all these files.
		 *
		 * a better approach might be to handle this
		 * on the trasrv side.
		 */
		/*
		oldsynctime = s->t->synctime;
		s->t->synctime = mkvtime():
		if(rpcwstat(s->sync->to, s->p, s->t) < 0){
			s->err = rpcerror();
			qsend(s->sync->eventq, s);
			return;
		}
		*/
		if(rm(s) < 0)
			return;
	}

	if(s->t->state==SFile && memcmp(s->t->sha1, s->f->sha1, sizeof s->t->sha1) == 0){
		/* BUG: call rpc to update metadata */
		syncfinish(s, 1);
		return;
	}

	if((rfd = rpcopen(s->sync->from, s->p, 'r')) < 0){
		s->err = rpcerror();
	Error:
		s->state = SyncError;
		qsend(s->sync->eventq, s);
		return;
	}
	if((wfd = rpcopen(s->sync->to, s->p, 'w')) < 0){
		s->err = rpcerror();
		rpcclose(s->sync->from, rfd);
		goto Error;
	}

	buf = emalloc(IOCHUNK);
	/*
	 * Try LBFS-style smart copy, fall back on simple byte copy.
	 * 
	 * TODO?: should run rpchashfile calls in parallel?
	 * TODO?: should overlap reads and writes in copybytes?
	 */
	roff = 0;
	hf = nil;
	ht = nil;
	USED(hf);
	USED(ht);
	if((hf = rpchashfile(s->sync->from, rfd)) == nil){
		e = rpcerror();
		if(strstr(e, "unknown RPC")){
			free(e);
			goto DumbCopy;
		}
		free(e);
	Error1:
		free(buf);
		rpcclose(s->sync->from, rfd);
	Error2:
		rpcclose(s->sync->to, wfd);
		goto Error;
	}

	if((ht = rpchashfile(s->sync->to, wfd)) == nil){
		/* file might simply not exist on to */
		free(hf);
		hf = nil;
		goto DumbCopy;
	}
	if(ht->nh == 0){
		free(ht);
		free(hf);
		goto DumbCopy;
	}
	qsort(ht->h, ht->nh, sizeof(ht->h[0]), hashcmp);

	nh = 0;
	nc = 0;
	for(i=0; i<hf->nh; i++){
		if((h = findhash(ht, hf->h[i].sha1)) != nil){
			if(nc){
				if(copybytes(s->sync->from, rfd, s->sync->to, wfd,
					buf, &roff, hf->h[i].off-nc, nc) < 0){
				ErrorCopy:
					free(hf);
					free(ht);
					s->err = rpcerror();
					goto Error1;
				}
				nc = 0;
			}
			if(nh+SHA1dlen > IOCHUNK){
				if(rpcwritehash(s->sync->to, wfd, buf, nh) < 0)
					goto ErrorCopy;
				nh = 0;
			}
			memmove(buf+nh, h->sha1, SHA1dlen);
			nh += SHA1dlen;
		}else{
			if(nh){
				if(rpcwritehash(s->sync->to, wfd, buf, nh) < 0)
					goto ErrorCopy;
				nh = 0;
			}
			nc += hf->h[i].n;
		}
	}
	if(nh){
		if(rpcwritehash(s->sync->to, wfd, buf, nh) < 0)
			goto ErrorCopy;
	}
	if(nc){
		if(copybytes(s->sync->from, rfd, s->sync->to, wfd,
			buf, &roff, hf->h[i-1].off+hf->h[i-1].n-nc, nc) < 0)
			goto ErrorCopy;
	}
	free(hf);
	free(ht);
	goto Finished;

	/*
	 * Straightforward dumb copy
	 */
DumbCopy:
	if(copybytes(s->sync->from, rfd, s->sync->to, wfd,
		buf, &roff, 0, s->f->length) < 0)
		goto ErrorCopy;

Finished:
	free(buf);
	if(rpcclose(s->sync->from, rfd) < 0){
		s->err = rpcerror();
		fprint(2, "rpcclose %s\n", s->err);
		goto Error2;
	}
	if(rpccommit(s->sync->to, wfd, s->f) < 0){
		s->err = rpcerror();
		fprint(2, "rpccommit %s\n", s->err);
		goto Error;
	}
	syncfinish(s, 1);
}

static void
copytree(Syncpath *s)
{
	if(s->t->state == SDir)
		abort();	/* should have chosen sync not copy */

	if(s->t->state == SFile){
		if(rpcremove(s->sync->to, s->p, s->f) < 0){
		Error:
			s->state = SyncError;
			s->err = rpcerror();
			qsend(s->sync->eventq, s);
			return;
		}
	}
	if(rpcmkdir(s->sync->to, s->p, s->f) < 0)
		goto Error;

	queuesynckids(s);
}

/* rm because remove is a library function on some systems */
static int
rm(Syncpath *s)
{
	if(rpcremove(s->sync->to, s->p, s->f) < 0){
		s->state = SyncError;
		s->err = rpcerror();
		qsend(s->sync->eventq, s);
		return -1;
	}
	return 0;
}

static void
work(Syncpath *s)
{
//print("worker %p %P\n", curthread, s->p);
	switch(s->state){
	default:
		fprint(2, "%P: bad state %d\n", s->p, s->state);
		return;
	case SyncRemove:
		dbg(DbgWork, "%P remove\n", s->p);
		if(rm(s) == 0)
			syncfinish(s, 1);
		break;
	case SyncCopy:
		dbg(DbgWork, "%P copy\n", s->p);
		copy(s);
		break;
	}
}

