#include <assert.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

#define nil ((void*) 0)

enum
{
	BUFSZ = (1<<15)
};

static void
fatal(char *s)
{
	fprintf(stderr, "%s: %s\n", s, strerror(errno));
	exit(1);
}

static int
writen(int fd, char *buf, int n)
{
	int m, k = 0;

	while(n > 0){
		if((m = write(fd, buf, n)) < 0){
			if(errno == EINTR)
				continue;
			fatal("write");
		}
		buf += m;
		n -= m;
		k += m;
	}

	return k;
}

static int
copy(int from, int to, int w)
{
	int n;
	char tmp[6];
	static char buf[BUFSZ+5];

	if((n = read(from, buf+5, BUFSZ)) > 0){
		sprintf(tmp, "%c%.4X", w?'e':'o', n);
		memmove(buf, tmp, 5);
		if(writen(to, buf, n+5) != n+5)
			fatal("writen");
	}

	return n;
}

static void
merge(int a, int b)
{
	int ao=1, bo=1, m = 1 + ((a>b)?a:b);
	fd_set rdset;

	while(ao || bo){
		FD_ZERO(&rdset);
		if(ao)
			FD_SET(a, &rdset);
		if(bo)
			FD_SET(b, &rdset);

		if(select(m, &rdset, nil, nil, nil) == -1){
			if(errno == EINTR)
				continue;
			fatal("select");
		}
		if(ao && FD_ISSET(a, &rdset))
			ao = (copy(a, 1, 0) != 0);
		if(bo && FD_ISSET(b, &rdset))
			bo = (copy(b, 1, 1) != 0);
	}

	return;
}

static void
usage(void)
{
	fprintf(stderr, "usage: stdmerge cmd ...\n");
}

int
main(int argc, char *argv[])
{
	int ps[2], pe[2];

	if(argc <= 1){
		usage();
		return 1;
	}

	if((pipe(ps) < 0) || (pipe(pe) < 0))
		fatal("pipe");

	switch(fork()){
	case -1:
		fatal("fork");

	case 0:
		close(ps[0]); close(pe[0]);
		if(dup2(ps[1], 1) < 0 || dup2(pe[1], 2) < 0)
			fatal("dup2");
		execvp(argv[1], argv+1);
		fatal("exec");

	default:
		close(ps[1]); close(pe[1]);
		merge(ps[0], pe[0]);
	}
	
	return 0;
}
