/* $Id: crypto.h,v 1.7 2007/12/08 15:17:55 hoganrobert Exp $ */
/*   Copyright (C) 2006 by Robert Hogan                                    *
 *   robert@roberthogan.net                                                */

/* Copyright (c) 2001 Matej Pfajfar.
 * Copyright (c) 2001-2004, Roger Dingledine.
 * Copyright (c) 2004-2006, Roger Dingledine, Nick Mathewson. */
/* See Tor LICENSE for licensing information */


/**
 * \file crypto.h
 *
 * \brief Headers for crypto.c
 **/

#define BASE64_DIGEST_LEN 27
#define DIGEST_LEN 20
#define HEX_DIGEST_LEN 40
#define SIZE_T_CEILING (sizeof(char)<<(sizeof(size_t)*8 - 1))

#define S2K_SPECIFIER_LEN 9

#include <qmap.h>
#include <qstring.h>

typedef struct crypto_digest_env_t crypto_digest_env_t;

/* random numbers */
int crypto_seed_rng(void);
int crypto_rand(char *to, size_t n);
int crypto_rand_int(unsigned int max);
QString crypto_rand_string(int len);

int read_all(int fd, char *buf, size_t count, int isSocket);

int base64_decode(char *dest, size_t destlen, const char *src, size_t srclen);
int digest_from_base64(char *digest, const char *d64);
void base16_encode(char *dest, size_t destlen, const char *src, size_t srclen);
int digest_to_base64(char *d64, const char *digest);
int base64_encode(char *dest, size_t destlen, const char *src, size_t srclen);
int base16_decode(char *dest, size_t destlen, const char *src, size_t srclen);

QString getFPDigestFromFP(const QString &fp);
QString getNickNameFromFPDigest(const QString &fpdigest);
QString getNickNameFromFP(const QString &fp);
QString getFPFromNickName(const QString &nickname);
QString getFPFromFPDigest(const QString &fp);
void storeServer(const QString &server,const QString &fp_identity);
void clearServers();
QString fp_identity(const QString &server);
QString server(const QString &fp_identity);
QString hashPassword(const char* secret);



