/*
 *  The Mana World
 *  Copyright 2004 The Mana World Development Team
 *
 *  This file is part of The Mana World.
 *
 *  The Mana World is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  The Mana World is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with The Mana World; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  $Id: radiobutton.cpp 4046 2008-04-07 15:41:22Z b_lindeijer $
 */

#include "radiobutton.h"

#include "../graphics.h"

#include "../resources/image.h"
#include "../resources/resourcemanager.h"

int RadioButton::instances = 0;
Image *RadioButton::radioNormal;
Image *RadioButton::radioChecked;
Image *RadioButton::radioDisabled;
Image *RadioButton::radioDisabledChecked;

RadioButton::RadioButton(const std::string& caption, const std::string& group,
        bool marked):
    gcn::RadioButton(caption, group, marked)
{
    if (instances == 0)
    {
        ResourceManager *resman = ResourceManager::getInstance();
        radioNormal = resman->getImage("graphics/gui/radioout.png");
        radioChecked = resman->getImage("graphics/gui/radioin.png");
        radioDisabled = resman->getImage("graphics/gui/radioout.png");
        radioDisabledChecked = resman->getImage("graphics/gui/radioin.png");
    }

    instances++;
}

RadioButton::~RadioButton()
{
    instances--;

    if (instances == 0)
    {
        radioNormal->decRef();
        radioChecked->decRef();
        radioDisabled->decRef();
        radioDisabledChecked->decRef();
    }
}

void RadioButton::drawBox(gcn::Graphics* graphics)
{
    Image *box = NULL;

    if (mMarked) {
        if (isEnabled()) {
            box = radioChecked;
        } else {
            box = radioDisabledChecked;
        }
    } else if (isEnabled()) {
        box = radioNormal;
    } else {
        box = radioDisabled;
    }

    if (box != NULL) {
        static_cast<Graphics*>(graphics)->drawImage(box, 2, 2);
    }
}
