# $Id: streamerror.tcl 650 2005-09-15 18:58:03Z aleksey $
# 

##########################################################################

package provide streamerror 1.0

##########################################################################

namespace eval streamerror {
    variable NS
    set NS(streams) "urn:ietf:params:xml:ns:xmpp-streams"

    foreach {cond message} \
	[list \
	    bad-format			[::msgcat::mc "Bad Format"] \
	    bad-namespace-prefix	[::msgcat::mc "Bad Namespace Prefix"] \
	    conflict			[::msgcat::mc "Conflict"] \
	    connection-timeout		[::msgcat::mc "Connection Timeout"] \
	    host-gone			[::msgcat::mc "Host Gone"] \
	    host-unknown		[::msgcat::mc "Host Unknown"] \
	    improper-addressing		[::msgcat::mc "Improper Addressing"] \
	    internal-server-error	[::msgcat::mc "Internal Server Error"] \
	    invalid-from		[::msgcat::mc "Invalid From"] \
	    invalid-id			[::msgcat::mc "Invalid ID"] \
	    invalid-namespace		[::msgcat::mc "Invalid Namespace"] \
	    invalid-xml			[::msgcat::mc "Invalid XML"] \
	    not-authorized		[::msgcat::mc "Not Authorized"] \
	    policy-violation		[::msgcat::mc "Policy Violation"] \
	    remote-connection-failed    [::msgcat::mc "Remote Connection Failed"] \
	    resource-constraint		[::msgcat::mc "Resource Constraint"] \
	    restricted-xml		[::msgcat::mc "Restricted XML"] \
	    see-other-host		[::msgcat::mc "See Other Host"] \
	    system-shutdown		[::msgcat::mc "System Shutdown"] \
	    undefined-condition		[::msgcat::mc "Undefined Condition"] \
	    unsupported-encoding	[::msgcat::mc "Unsupported Encoding"] \
	    unsupported-stanza-type	[::msgcat::mc "Unsupported Stanza Type"] \
	    unsupported-version		[::msgcat::mc "Unsupported Version"] \
	    xml-not-well-formed		[::msgcat::mc "XML Not Well-Formed"]] \
    {
	set streamerror_desc($cond) $message
    }
}

##########################################################################

proc streamerror::condition {error} {
    return [lindex [cond_msg $error] 0]
}

##########################################################################

proc streamerror::message {error} {
    return [lindex [cond_msg $error] 1]
}

##########################################################################

proc streamerror::cond_msg {error} {
    variable NS
    variable streamerror_desc

    jlib::wrapper:splitxml $error tag1 vars1 isempty1 chdata1 children1
    if {[llength $children1] == 0} {
	# Legacy error
	if {$chdata1 != ""} {
	    set chdata1 " ($chdata1)"
	}
	return [list legacy \
		     [format [::msgcat::mc "Stream Error%s%s"] $chdata1 ""]]
    } else {
	# XMPP error
	set condition undefined-condition
	set description ""
	set textdescription ""
	foreach errelem $children1 {
	    jlib::wrapper:splitxml $errelem tag vars isempty chdata children
	    set xmlns [jlib::wrapper:getattr $vars xmlns]
	    set cond $tag
	    switch -- $cond {
		text {
		    if {$xmlns == $NS(streams)} {
			set textdescription ": $chdata"
		    }
		}
		undefined-condition {
		    # TODO
		}
		default {
		    if {[info exists streamerror_desc($cond)]} {
			set condition $cond
			set description " ($streamerror_desc($cond))"
		    }
		}
	    }
	}
	return [list $condition \
		     [format [::msgcat::mc "Stream Error%s%s"] \
			     $description $textdescription]]
    }
}

##########################################################################

