#  namespaces.tcl --
#  
#      This file is part of the jabberlib. It lists Jabber
#      namespaces registered by JSF.
#      
#  Copyright (c) 2005 Sergei Golovan <sgolovan@nes.ru>
#   
# $Id: namespaces.tcl 684 2006-05-11 22:07:25Z aleksey $

##########################################################################

package provide namespaces 1.0

##########################################################################

namespace eval :: {
    array set NS [list \
	tls	    "urn:ietf:params:xml:ns:xmpp-tls" \
	sasl	    "urn:ietf:params:xml:ns:xmpp-sasl" \
	bind	    "urn:ietf:params:xml:ns:xmpp-bind" \
	session	    "urn:ietf:params:xml:ns:xmpp-session" \
	iq-auth	    "http://jabber.org/features/iq-auth" \
	iq-register "http://jabber.org/features/iq-register" \
	fcompress   "http://jabber.org/features/compress" \
	compress    "http://jabber.org/protocol/compress" \
	component   "jabber:component:accept" \
	auth	    "jabber:iq:auth" \
	register    "jabber:iq:register" \
	roster	    "jabber:iq:roster" \
	signed      "jabber:x:signed" \
	encrypted   "jabber:x:encrypted" \
	iqavatar    "jabber:iq:avatar" \
	xavatar     "jabber:x:avatar" \
	xconference "jabber:x:conference" \
	data	    "jabber:x:data" \
	event       "jabber:x:event" \
	xroster     "jabber:x:roster" \
	rosterx     "http://jabber.org/protocol/rosterx" \
	chatstate   "http://jabber.org/protocol/chatstates" \
	commands    "http://jabber.org/protocol/commands" \
	privacy     "jabber:iq:privacy" \
	private     "jabber:iq:private" \
	delimiter   "roster:delimiter" \
	bookmarks   "storage:bookmarks" \
	tkabber:groups "tkabber:bookmarks:groups" \
	pubsub      "http://jabber.org/protocol/pubsub" \
	pubsub#owner "http://jabber.org/protocol/pubsub#owner" \
	disco#publish "http://jabber.org/protocol/disco#publish"
    ]
}

##########################################################################

