/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#ifndef INDII_GUI_INFOBAR_HPP
#define INDII_GUI_INFOBAR_HPP

#ifndef WX_28
#include "wx/infobar.h"
#else
#include "wx/panel.h"
#endif

/**
 * @def INDII_INFOBAR_BASE
 *
 * Base type of indii::InfoBar.
 */
#ifndef WX_28
#define INDII_INFOBAR_BASE wxInfoBar
#else
#define INDII_INFOBAR_BASE wxPanel
#endif

namespace indii {
class Window;
/**
 * Info bar for display of tips.
 */
class InfoBar : public INDII_INFOBAR_BASE {
public:
  /**
   * Constructor.
   */
  InfoBar(Window* parent);

  /**
   * Show generic message at startup, with open button.
   */
  void showStartMessage();

  /**
   * Show informational message at any other time, with close button.
   *
   * @param msg Message.
   * @param id Id of the message. This is used to record the message having
   * been seen, so that it is not displayed again. A value less than zero
   * will ensure that the message is always displayed.
   */
  void showInfoMessage(const wxString& msg, const int id = -1);

  /**
   * Remove all buttons.
   */
  void clearButtons();

  /**
   * Button events.
   */
  void OnButtonOpen(wxCommandEvent& evt);
  void OnButtonClose(wxCommandEvent& evt);

private:
  /**
   * Parent window.
   */
  Window* window;

  /**
   * Id of message currently displayed.
   */
  int id;

  /**
   * Used to track which buttons are added, as wxInfoBar does not provide an
   * interface to query this itself.
   */
  bool hasOpenButton, hasCloseButton;

  DECLARE_EVENT_TABLE()
};
}

#endif
