/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 418 $
 * $Date: 2012-02-29 20:01:33 +0800 (Wed, 29 Feb 2012) $
 */
#include "InfoBar.hpp"

#include "Window.hpp"
#include "../meta.hpp"

#include "wx/config.h"

using namespace indii;

InfoBar::InfoBar(Window* parent) : INDII_INFOBAR_BASE(parent),
    window(parent), id(-1), hasOpenButton(false), hasCloseButton(false) {
  //
}

void InfoBar::showStartMessage() {
  #ifndef WX_28
  clearButtons();
  #ifndef __WXMAC__
  AddButton(wxID_OPEN);
  hasOpenButton = true;
  #else
  AddButton(wxID_CLOSE);
  hasCloseButton = true;
  #endif
  ShowMessage(_("Open a photo to get started"), wxICON_INFORMATION);
  #endif
}

void InfoBar::showInfoMessage(const wxString& msg, const int id) {
  #ifndef WX_28
  bool show = true;
  if (id >= 0) {
    /* check if this message has been displayed before */
    wxString key;
    key << id;
    wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
    config.SetPath(_("Messages"));
    show = config.ReadBool(key, true);
    this->id = id;
  }
  if (show) {
    clearButtons();
    AddButton(wxID_CLOSE);
    hasCloseButton = true;
    ShowMessage(msg, wxICON_INFORMATION);
  } else {
    Dismiss();
  }
  #endif
}

void InfoBar::OnButtonOpen(wxCommandEvent& evt) {
  #ifndef WX_28
  Dismiss();
  window->OnButtonOpen(evt);
  id = -1;
  #endif
}

void InfoBar::OnButtonClose(wxCommandEvent& evt) {
  #ifndef WX_28
  Dismiss();
  if (id >= 0) {
    /* record this message as having been displayed before */
    wxString key;
    key << id;
    wxConfig config(_(PACKAGE_TARNAME), _("indii.org"));
    config.SetPath(_("Messages"));
    config.Write(key, false);
  }
  id = -1;
  #endif
}

void InfoBar::clearButtons() {
  #ifndef WX_28
  if (hasOpenButton) {
    RemoveButton(wxID_OPEN);
    hasOpenButton = false;
  }
  if (hasCloseButton) {
    hasCloseButton = false;
    RemoveButton(wxID_CLOSE);
  }
  #endif
}

BEGIN_EVENT_TABLE(InfoBar, INDII_INFOBAR_BASE)
EVT_BUTTON(wxID_OPEN, InfoBar::OnButtonOpen)
EVT_BUTTON(wxID_CLOSE, InfoBar::OnButtonClose)
END_EVENT_TABLE()
