/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2008 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "DLTmath.h"
#include "gamma_dist.h"

double 
binomialdev(double pp, int n)
{
    int             j;
    static int      nold = (-1);
    double          am, em, g, angle, p, bnl, sq, t, y;
    static double   pold = (-1.0), pc, plog, pclog, en, oldg;

    p = (pp <= 0.5 ? pp : 1.0 - pp);
    am = n * p;

    if (n < 25)
    {
        bnl = 0.0;

        for (j = 1; j <= n; j++)
            if (genrand_real2() < p)
                ++bnl;
    }
    else if (am < 1.0)
    {
        g = exp(-am);
        t = 1.0;

        for (j = 0; j <= n; j++)
        {
            t *= genrand_real2();
            if (t < g)
                break;
        }

        bnl = (j <= n ? j : n);
    }
    else
    {
        if (n != nold)
        {
            en = n;
            oldg = lgamma(en + 1.0);
            nold = n;
        }

        if (p != pold)
        {
            pc = 1.0 - p;
            plog = log(p);
            pclog = log(pc);
            pold = p;
        }

        sq = sqrt(2.0 * am * pc);

        do
        {
            do
            {
                angle = MY_PI * genrand_real2();
                y = tan(angle);
                em = sq * y + am;
            } while (em < 0.0 || em >= (en + 1.0));

            em = floor(em);
            t = 1.2 * sq * (1.0 + y * y) * exp(oldg - lgamma(em + 1.0)
                     - lgamma(en - em + 1.0) + em * plog + (en - em) * pclog);
        } while (genrand_real2() > t);

        bnl = em;
    }

    if (p != pp)
        bnl = n - bnl;

    return (bnl);
}


void
multinomialdev(int n, int dim, double *p, double *x)
{
    int             i;
    double          sum, ptemp;

    sum = 1;

    for (i = 0; i < dim; i++)
    {
        if (p[i] > 0.0)
        {
            ptemp = p[i] / sum;
            x[i] = binomialdev(ptemp, n);
            n = n - (int) x[i];
            sum = sum - p[i];
        }
        else
            x[i] = 0.0;
    }
}


void
multinomial_eqdev(int n, double p, double *x, int dim)
{
    int             i;
    double          sum, ptemp;

    sum = 1.0;
    for (i = 0; i < dim; ++i)
    {
        ptemp = p / sum;
        x[i] = binomialdev(ptemp, n);
        n -= (int) x[i];
        sum -= p;
    }
}
