/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBMALLOC_SEEN
#define PDBMALLOC_SEEN

#include "Coords.h"
#include "PDBCoords.h"

Seq2PDB
*Seq2pdbInit(void);

void
Seq2pdbAlloc(Seq2PDB *seq2pdb, const int seqnum);

void
Seq2pdbDestroy(Seq2PDB *seq2pdb);

Algorithm
*AlgorithmInit(void);

Statistics
*StatsInit(void);

CoordsArray
*CoordsArrayInit(void);

void
CoordsArrayAllocNum(CoordsArray *cdsA, const int cnum);

void
CoordsArrayAllocLen(CoordsArray *cdsA, const int vlen);

void
CoordsArrayAlloc(CoordsArray *cdsA, const int cnum, const int vlen);

void
CoordsArraySetup(CoordsArray *cdsA);

void
DistMatsAlloc(CoordsArray *cdsA);

void
DistMatsDestroy(CoordsArray *cdsA);

void
CovMatsDestroy(CoordsArray *cdsA);

void
PCAAlloc(CoordsArray *cdsA);

void
PCADestroy(CoordsArray *cdsA);

void
CoordsArrayDestroy(CoordsArray *cdsA);

Coords
*CoordsInit(void);

void
CoordsAlloc(Coords *coords, const int vlen);

void
CoordsSetup(Coords *coords);

void
CoordsDestroy(Coords *coords);

PDBCoordsArray
*PDBCoordsArrayInit(void);

void
PDBCoordsArrayAllocNum(PDBCoordsArray *pdbA, const int cnum);

void
PDBCoordsArrayAllocLen(PDBCoordsArray *pdbA, const int vlen);

void
PDBCoordsArrayAlloc(PDBCoordsArray *pdbA, const int cnum, const int vlen);

void
PDBCoordsArrayDestroy(PDBCoordsArray *pdbA);

PDBCoords
*PDBCoordsInit(void);

void
PDBCoordsAlloc(PDBCoords *pdbcoords, const int vlen);

void
PDBCoordsDestroy(PDBCoords *coords);

#endif
