/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PROCLAPACKSVD_SEEN
#define PROCLAPACKSVD_SEEN

double
CalcInnProdNorm(const Coords *coords);

double
CalcInnProdRotNorm(const Coords *coords, const double **rotmat);

double
ProcLAPACKSVDvan(const Coords *coords1, const Coords *coords2, double **rotmat,
                 double **Rmat, double **Umat, double **VTmat, double *sigma);

double
ProcLAPACKSVD(const Coords *coords1, const Coords *coords2, double **rotmat,
              const double *weights, const double *axesw,
              double **Rmat, double **Umat, double **VTmat, double *sigma);

double
ProcLAPACKSVDCov(Coords *coords1, Coords *coords2, double **rotmat,
                 const double **covmat, const double *axesw,
                 double **Rmat, double **Umat, double **VTmat,
                 double *sigma);

double
ProcLAPACKSVDAx(const Coords *coords1, const Coords *coords2, double **rotmat,
                const double *weights, const double *axesw, const double **AxWtMat,
                double **Rmat, double **Umat, double **VTmat, double *sigma);

#endif
