/* Macros in this file are taken from mule-2.2 src/coding.h (except for the
 * trivial ones, mlchar2iso and mlchar2euc) and modified by Takafumi Sakurai
 * 1997. cofing.h is covered by GPL.
 */

/*
 * Ml char conversion macros
 */
#define	mlchar2r(i, c) \
{ \
    c = mlrep_char(i)|0x80; \
}

#define	mlchar2iso(i, c1, c2) \
{ \
    c1 = mlrep_char_fst(i); \
    c2 = mlrep_char_snd(i); \
}

#define	mlchar2euc(i, c1, c2) \
{ \
    c1 = mlrep_char_fst(i)|0x80; \
    c2 = mlrep_char_snd(i)|0x80; \
}

#define	sj2iso(i1, i2, c1, c2) \
{ \
    if (i2 >= 0x9f) { \
	if (i1 >= 0xe0) c1 = (i1 - 0xb0) * 2; \
	else c1 = (i1 - 0x70) * 2; \
	c2 = i2 - 0x7e; \
    } else { \
	if (i1 >= 0xe0) c1 = (i1 - 0xb0) * 2 - 1; \
	else c1 = (i1 - 0x70) * 2 - 1; \
	if (i2 >= 0x7f) c2 = i2 - 0x20; \
	else c2 = i2 - 0x1f; \
    } \
}

#define	mlchar2sj(i, c1, c2) \
{ \
    textchar i1, i2; \
 \
    i1 = mlrep_char_fst(i); \
    i2 = mlrep_char_snd(i); \
    if (i1 & 1) { \
	if (i1 < 0x5f) c1 = i1/2 + 0x71; \
	else c1 = i1/2 + 0xb1; \
	if (i2 >= 0x60) c2 = i2 + 0x20; \
	else c2 = i2 + 0x1f; \
    } else { \
	if (i1 < 0x5f) c1 = i1/2 + 0x70; \
	else c1 = i1/2 + 0xb0; \
	c2 = i2 + 0x7e; \
    } \
}

#define	bvh2iso(i1, i2, mc, c1, c2) \
{ \
    unsigned int temp_i \
	= (i1 - 0xA1) * (0xFF-0xA1+0x7F-0x40) + i2 - (i2 < 0x7F ? 0x40 : 0x62); \
 \
    if (i1 < 0xC6 || i1 == 0xC6 && i2 < 0x7F) { \
	mc = MC_BIG51; \
    } else { \
	mc = MC_BIG52; \
	temp_i -= (0xFF-0xA1+0x7F-0x40) * (0xC6-0xA1) + (0x7F-0x40); \
    } \
    c1 = temp_i / (0xFF-0xA1) + 0x21; \
    c2 = temp_i % (0xFF-0xA1) + 0x21; \
}

#define	bve2iso(i1, i2, mc, c1, c2) \
{ \
    unsigned int temp_i \
	= (i1 - 0xA1) * (0xFF-0xA1+0x7F-0x40) + i2 - (i2 < 0x7F ? 0x40 : 0x62); \
 \
    if (i1 < 0xC6 || i1 == 0xC6 && i2 < 0x7F) { \
	mc = MC_BIG51; \
    } else { \
	mc = MC_BIG52; \
	temp_i -= (0xFF-0xA1+0x7F-0x40) * (0xC9-0xA1); \
    } \
    c1 = temp_i / (0xFF-0xA1) + 0x21; \
    c2 = temp_i % (0xFF-0xA1) + 0x21; \
}

#define	mlchar2bvh(mc, i, c1, c2) \
{ \
    unsigned int temp_i \
	= (mlrep_char_fst(i) - 0x21) * (0xFF-0xA1) + (mlrep_char_snd(i) - 0x21); \
 \
    if (mc == MC_BIG52) { \
	temp_i += (0xFF-0xA1+0x7F-0x40) * (0xC6-0xA1) + (0x7F-0x40); \
    } \
    c1 = temp_i / (0xFF-0xA1+0x7F-0x40) + 0xA1; \
    c2 = temp_i % (0xFF-0xA1+0x7F-0x40); \
    c2 += c2 < 0x3F ? 0x40 : 0x62; \
}

#define	mlchar2bve(mc, i, c1, c2) \
{ \
    unsigned int temp_i \
	= (mlrep_char_fst(i) - 0x21) * (0xFF-0xA1) + (mlrep_char_snd(i) - 0x21); \
 \
    if (mc == MC_BIG52) { \
	temp_i += (0xFF-0xA1+0x7F-0x40) * (0xC9-0xA1); \
    } \
    c1 = temp_i / (0xFF-0xA1+0x7F-0x40) + 0xA1; \
    c2 = temp_i % (0xFF-0xA1+0x7F-0x40); \
    c2 += c2 < 0x3F ? 0x40 : 0x62; \
}
