/*
 * The configuration file for XLDVI
 *   by Hirotsugu Kakugawa, Hiroshima University
 */  

#define PROG_NAME               "xldvi"
#define PROG_NAME_RESOURCE      "Xldvi"
#define WINDOW_ENLARGE_RATIO    1.3



/* 
 * Default Paper Size   ("A4", "B5", "LEETER", etc.)
 *   resource name : "paperSize"
 */
#define DEFAULT_PAPER           "A4"

/*
 * Default Paper Orientation   ("Portrait" or "Landscape")
 *   resource name : "orientation"
 */
#define DEFAULT_ORIENTATION     "Portrait"

/*
 * Default shrink factor:  
 *   resource names : "shrinkFactor"
 */
#define DEFAULT_SHRINK_FACTOR   "5"
#define SHRINK_MIN    1.0
#define SHRINK_MAX    32.0

/*
 * Default DPI value ("300", "400", "600", etc.)
 *   resource name : "dpi"
 */
#define DEFAULT_DPI	        "300"

/*
 * Default Device Mode Name for Kpathsea Library ("cx", etc.)
 *   resource name : "kpathsea_mode"
 */
#define DEFAULT_KPATHSEA_MODE   "cx"

/*
 * VFlib
 *   resource name : "vflibcap"
 */
#define DEFAULT_VFLIBCAP        "vflibcap-tex"

/*
 * Display offset
 *   resource names : "offsetX". "offsetY"  (in inch)
 */
#define DEFAULT_OFFSET_X        "1.00"
#define DEFAULT_OFFSET_Y        "1.00"

/*
 * Paper Color
 *   resource names : "colorCharacter", "colorPaper", 
 *                    "colorBackground", colorFrame",
 *                    "visualText"
 */
#define DEFAULT_PAPER_CHAR_COLOR         "black"
#define DEFAULT_PAPER_PAPER_COLOR        "white"
#define DEFAULT_PAPER_BACKGROUND_COLOR   "gray"
#define DEFAULT_PAPER_FRAME_COLOR        "black"
#define DEFAULT_VISUAL_TEXT              "Monochrome"

/*
 * Polling Interval
 *   resource name : "pollingInterval"
 */
#define DEFAULT_POLLING_INTERVAL    "50"


/*
 * Drawing PostScript figures by Ghostscript (gs).
 *   resource names : "epsStyle", "drawEPSFigures", "visualEPS", 
 *                    "gsPath", "gsTimeOut" 
 */
#define DEFAULT_EPS_FIGURE_STYLE    "LaTeX2e/graphics.sty"
#define DEFAULT_DRAW_EPS_FIGS       "Yes"
#define DEFAULT_VISUAL_EPS          "Monochrome"
#define DEFAULT_GS_PATH             "gs"
/*#define DEFAULT_GS_PATH             "/usr/local/bin/gs"*/
#define DEFAULT_GS_TIMEOUT          "30"   /* in Sec */


/*
 * Cache Size
 *   resource name : "pageCacheSize"
 */
#define DEFAULT_PAGE_CACHE_SIZE     "4"

/*
 * Temporary directory
 *   resource name : "tempDirectory"
 */
#define DEFAULT_TEMP_DIRECTORY      "/var/tmp"

/*EOF*/
