/*  XGDVI
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
#  include <fcntl.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "libdvi29.h"
#include "defs.h"
#include "xgdvi.h"
#include "files.h"
#include "gui.h"


#define WIDTH    600
#define HEIGHT   400


static int        LicenseShown = 0;
static GtkWidget *License      = NULL;


static void
on_destry                              (GtkObject      *obj,
                                        gpointer        user_data);

void
on_lcButtonCancel_clicked              (GtkButton       *button,
                                        gpointer         user_data);


static char *LicenseShort[] = {
  "XGDVI\n",
  "Copyright (C) 1999  Hirotsugu Kakugawa\n",
  "\n",
  "This program is free software; you can redistribute it and/or modify\n",
  "it under the terms of the GNU General Public License as published by\n",
  "the Free Software Foundation; either version 2 of the License, or\n",
  "(at your option) any later version. \n",
  "This program is distributed in the hope that it will be useful,\n",
  "but WITHOUT ANY WARRANTY; without even the implied warranty of\n",
  "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n",
  "GNU General Public License for more details.\n",
  NULL};



GtkWidget*
create_License() 
{
  GtkWidget *dialog_vbox;
  GtkWidget *separator;
  GtkWidget *achbox;
  GtkWidget *scrolled_win;
  GtkWidget *text;
  GtkWidget *button;
  char       buff[1024], f[1024];
  FILE      *fp;
  int        i;
  
  License = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  LicenseShown = 0;

#if 0
  gtk_widget_set_events(License, GDK_KEY_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT(License), "key_press_event", 
		     GTK_SIGNAL_FUNC(event_key_press), NULL);
#endif
  gtk_signal_connect(GTK_OBJECT(License), "destroy", 
		     GTK_SIGNAL_FUNC(on_destry), NULL);
  gtk_signal_connect (GTK_OBJECT (License), "destroy",
		      GTK_SIGNAL_FUNC(gtk_widget_destroyed), NULL);

  gtk_window_set_title (GTK_WINDOW (License), _("xgdvi: License"));
  gtk_widget_set_usize (License, WIDTH, HEIGHT);
  gtk_container_set_border_width (GTK_CONTAINER (License), 10);

  dialog_vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_add (GTK_CONTAINER (License), dialog_vbox);
  gtk_widget_show (dialog_vbox);

  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), scrolled_win, TRUE, TRUE, 5);
  gtk_widget_show (scrolled_win);
  gtk_scrolled_window_set_placement (GTK_SCROLLED_WINDOW (scrolled_win),
				     GTK_CORNER_BOTTOM_RIGHT);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

  text = gtk_text_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scrolled_win), text);
  gtk_widget_show (text);
  gtk_text_set_editable (GTK_TEXT (text), FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(text), FALSE);
  gtk_text_set_editable(GTK_TEXT(text), FALSE);

  gtk_text_freeze (GTK_TEXT (text));
  sprintf(f, "%s%s%s", XGDVI_CONFIG_DIR, "/", _("License.txt"));
  if ((fp = fopen(f, "r")) == NULL){
    for (i = 0; LicenseShort[i] != NULL; i++)
      gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, 
		       LicenseShort[i], strlen(LicenseShort[i]));
  } else {
    while (fgets(buff, sizeof(buff)-1, fp) != NULL)
      gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, buff, strlen(buff));
    fclose(fp);
  }
  gtk_text_thaw (GTK_TEXT (text));
  
  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (dialog_vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show (separator);

  achbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(achbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(achbox), 5);
  gtk_box_pack_end (GTK_BOX (dialog_vbox), achbox, FALSE, FALSE, 0);
  gtk_widget_show (achbox);

  button = gtk_button_new_with_label (_("Close"));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (achbox), button, TRUE, TRUE, 0);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (on_lcButtonCancel_clicked), NULL);
  gtk_tooltips_set_tip(gtk_tooltips_new(), button,
		       (gchar*) "Close the license window.",
		       (gchar*) NULL);

  return License;  
}


static void
on_destry                              (GtkObject       *obj,
                                        gpointer         user_data)
{
  LicenseShown = 0;
  License = create_License ();
}


void
on_License_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  if (LicenseShown == 0){
    LicenseShown = 1;
    gtk_widget_show (License);
  } else {
    LicenseShown = 0;
    gtk_widget_hide (License);
  }
}

void
show_License(void)
{
  if (LicenseShown == 0){
    LicenseShown = 1;
    gtk_widget_show (License);
  }
}

void
hide_License(void)
{
  if (LicenseShown == 1){
    LicenseShown = 0;
    gtk_widget_hide (License);
  }
}


void
on_lcButtonCancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  on_License_clicked(NULL, NULL);
}
