/*
 * defs.h
 */


#ifndef  __DVILIB_DEFS_H__
#define  __DVILIB_DEFS_H__

#if 0
extern void vf_free(void*);
# define free(p)  vf_free(p)
#endif


#define DEFAULT_DPI               300
#define DEFAULT_GS_PROGRAM_PATH   "gs"
#define DEFAULT_GS_TIMEOUT         30
#define DEFAULT_TEMP_DIR          "/var/tmp"

#define DEVMODES_CNF              "devmodes.cnf"
#define PAPERS_CNF                "papers.cnf"

#define EPS_BITMAP_INCREMENTAL_DISPLAY   10

#define FONT_SUFFIX       "pk"

#define TRUE   (1==1)
#define FALSE  (1==0)
typedef int  BOOL;

#define Public    /**/      /* public */
#define Glocal    /**/      /* public within dvilib */
#define Private   static

#define  FONT_CACHE_SIZE        30000
#define  FONT_CACHE_HASH_SIZE    3299

extern void dvi_put_bitmap(DVI_DEVICE,DVI,DVI_BITMAP,int,long,long,long,long);
extern void dvi_put_rectangle(DVI_DEVICE,DVI,long,long,long,long);
extern int  DVI_read_paper_size_db(void);
extern int  DVI_read_device_mode_db(void);


#ifndef FOPEN_MODE_BIN
#  if defined(VMS) || defined(VMCMS) || defined(DOS) || defined(OS2) \
      || defined(WIN32) || defined(__DJGPP__) || defined(__CYGWIN32__)
#    define   FOPEN_RD_MODE_BIN   "rb"
#    define   FOPEN_RD_MODE_TEXT  "rt"
#    define   FOPEN_WR_MODE_BIN   "wb"
#    define   FOPEN_WR_MODE_TEXT  "wt"
#  else
#    define   FOPEN_RD_MODE_BIN   "r"
#    define   FOPEN_RD_MODE_TEXT  "r"
#    define   FOPEN_WR_MODE_BIN   "w"
#    define   FOPEN_WR_MODE_TEXT  "w"
#  endif
#endif

#define ALLOC_IF_ERR(v,t) \
          if ((v = (t*)calloc(1, sizeof(t))) == NULL)
#define ALLOCN_IF_ERR(v,t,n) \
          if ((v = (t*)calloc(n, sizeof(t))) == NULL)
#define MALLOC_IF_ERR(v,n) \
          if ((v = malloc(n)) == NULL)
#define MALLOC_STR_IF_ERR(v,n) \
          if ((v = (char*)malloc(n)) == NULL)
#define STRDUP(new,src) \
          (new = (char*)malloc(strlen(src)+1), \
             (new == NULL) ? NULL : (strcpy(new, src), new))
#define free_if_non_null(p)  if ((p) != NULL){ free(p); }

#define PROP_TEST(d,i)  DVI_PROPERTY_TEST(PD(d,property),i)

#if STDC_HEADERS
#  include <string.h>
#  define memclr(a,n)      memset((a),0,(n))
#else
#  ifndef HAVE_MEMCMP
#    define memcmp(a1,a2,n)  bcmp((a1),(a2),(n))
#    define memclr(a,n)      bzero((a),(n))
#  else
#    define memclr(a,n)      memset((a),0,(n))
#  endif /*HAVE_MEMCMP*/
#endif 


/* IMPORTANT ASSUMPTION:
 *   char:  at least 8 bits
 *   int:   at least 16 bits
 *   long:  at least 32 bits
 */
typedef  char           INT1;
typedef  unsigned char  UINT1;
typedef  int            INT2;
typedef  unsigned int   UINT2;
typedef  long           INT3;
typedef  unsigned long  UINT3;
typedef  long           INT4;
typedef  unsigned long  UINT4;

#define READ_INT1(fp)    (INT1)dvi_read_intn((fp), 1)
#define READ_UINT1(fp)   (UINT1)dvi_read_uintn((fp), 1)
#define READ_INT2(fp)    (INT2)dvi_read_intn((fp), 2)
#define READ_UINT2(fp)   (UINT2)dvi_read_uintn((fp), 2)
#define READ_INT3(fp)    (INT3)dvi_read_intn((fp), 3)
#define READ_UINT3(fp)   (UINT3)dvi_read_uintn((fp), 3)
#define READ_INT4(fp)    (INT4)dvi_read_intn((fp), 4)
#define READ_UINT4(fp)   (UINT4)dvi_read_uintn((fp), 4)
#define READ_INTN(fp,k)  (INT4)dvi_read_intn((fp), (k))
#define READ_UINTN(fp,k) (UINT4)dvi_read_uintn((fp), (k))
#define SKIP_N(fp,k)     dvi_skip_n((fp), (k))

Glocal long           dvi_read_intn(FILE*,int);
Glocal unsigned long  dvi_read_uintn(FILE*,int);
Glocal void           dvi_skip_n(FILE*,int);

#endif /*__DVILIB_DEFS_H__*/

/*EOF*/
