/*

    File: swap.c

    Copyright (C) 1998-2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#include "types.h"
#include "common.h"
#include "swap.h"
#include "fnctdsk.h"
static int set_Linux_SWAP_info(const union swap_header *swap_header,partition_t *partition);

int check_Linux_SWAP(disk_t *disk_car,partition_t *partition,const int debug)
{
  unsigned char *buffer=(unsigned char*)MALLOC(SWAP_SIZE);
  if(disk_car->read(disk_car,SWAP_SIZE, buffer, partition->part_offset)!=0)
  {
    free(buffer);
    return 1;
  }
  if(test_Linux_SWAP(disk_car,(union swap_header*)buffer,partition,debug,0)!=0)
  {
    free(buffer);
    return 1;
  }
  set_Linux_SWAP_info((union swap_header*)buffer,partition);
  free(buffer);
  return 0;
}

static int set_Linux_SWAP_info(const union swap_header *swap_header,partition_t *partition)
{
  partition->name[0]='\0';
  switch(partition->upart_type)
  {
    case UP_LINSWAP:
      snprintf(partition->info,sizeof(partition->info),"SWAP version %u",swap_header->info.version);
      break;
    case UP_LINSWAP2:
      snprintf(partition->info,sizeof(partition->info),"SWAP2 version %u",swap_header->info.version);
/*      set_part_name(partition,swap_header->info.volume_name,16); */
      break;
    default:
      partition->info[0]='\0';
      break;
  }
  return 0;
}

int test_Linux_SWAP(disk_t *disk_car, const union swap_header *swap_header,partition_t *partition,const int debug, const int dump_ind)
{
  if(memcmp(swap_header->magic.magic,"SWAP-SPACE",10)==0)
  {
    partition->upart_type=UP_LINSWAP;
    return 0;
  }
  if(memcmp(swap_header->magic.magic,"SWAPSPACE2",10)==0)
  {
    if(swap_header->info.last_page==0)
      return 1;
    partition->upart_type=UP_LINSWAP2;
    return 0;
  }
  return 1;
}

int recover_Linux_SWAP(disk_t *disk_car, const union swap_header *swap_header,partition_t *partition,const int debug, const int dump_ind)
{
  if(test_Linux_SWAP(disk_car,swap_header,partition,debug,dump_ind)!=0)
    return 1;
  set_Linux_SWAP_info(swap_header,partition);
  partition->part_type_i386=P_LINSWAP;
  partition->part_type_sun=PSUN_LINSWAP;
  partition->part_type_mac=PMAC_SWAP;
  switch(partition->upart_type)
  {
    case UP_LINSWAP:
      {
	int i, j;
	for(i=PAGE_SIZE-10-1;i>=0;i--)
	  if(swap_header->magic.reserved[i]!=(char)0)
	    break;
	for(j=7;j>=0;j--)
	  if((swap_header->magic.reserved[i]&(1<<j))!=(char)0)
	    break;
	partition->part_size=(uint64_t)((8*i+j+1)*PAGE_SIZE);
      }
      break;
    case UP_LINSWAP2:
      partition->part_size=(uint64_t)(swap_header->info.last_page - 1)*PAGE_SIZE;
      break;
    default:
      return 1;
  }
  return 0;
}
