/***************************************************************************
 *  IChannelStreamedMedia.cs
 *
 *  Copyright (C) 2006 INdT
 *  Written by 
 *	Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *	Kenneth Christiansen <kenneth.christiansen@gmail.com>
 *	Renato Araujo Oliveira Filho <renato.filho@indt.org>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW:
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using NDesk.DBus;

namespace org.freedesktop.Telepathy
{
	public delegate void StreamAddedHandler (uint stream_id, uint contact_handle, StreamType stream_type);
	public delegate void StreamDirectionChangedHandler (uint stream_id, StreamDirection stream_direction, StreamPendingFlags pending_flags);
	public delegate void StreamErrorHandler (uint stream_id, uint errno, string message);
	public delegate void StreamRemovedHandler (uint stream_id);
	public delegate void StreamStateChangedHandler (uint stream_id, StreamState stream_state);

	public enum StreamPendingFlags : uint
	{
		LocalSend = 1,
		RemoteSend = 2
	}

	public struct StreamInfo
	{
		public uint Id;
		public uint ContactHandle;
		public StreamType Type;
		public StreamState State;
		public StreamDirection Direction;
		public StreamPendingFlags PendingFlags;
	}

	[Interface ("org.freedesktop.Telepathy.Channel.Type.StreamedMedia")]
	public interface IChannelStreamedMedia : IChannel
	{
		event StreamAddedHandler StreamAdded;
		event StreamDirectionChangedHandler StreamDirectionChanged;
		event StreamErrorHandler StreamError;
		event StreamRemovedHandler StreamRemoved;
		event StreamStateChangedHandler StreamStateChanged;

		StreamInfo[] ListStreams ();
		void RemoveStreams (uint[] streams);
		void RequestStreamDirection (uint stream_id, uint stream_direction);
		StreamInfo[] RequestStreams (uint contact_handle, uint[] types);
	}
}
