/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-wdg-generic-conn-param.h:
 * Widgets Generic Connection Parameter
 * Used by TIDialogRequestConn ("Request Connection" dialog)
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_WDG_GENERIC_CONN_PARAM_H__
#define __TI_WDG_GENERIC_CONN_PARAM_H__

#include "wdg-conn-param.h"

typedef struct _TIWdgGenericConnParam TIWdgGenericConnParam;
typedef struct _TIWdgGenericConnParamClass TIWdgGenericConnParamClass;

#define TI_TYPE_WDG_GENERIC_CONN_PARAM \
  (ti_wdg_generic_conn_param_get_type ())
#define TI_WDG_GENERIC_CONN_PARAM(object) \
  (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_WDG_GENERIC_CONN_PARAM, \
                               TIWdgGenericConnParam))
#define TI_WDG_GENERIC_CONN_PARAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_WDG_GENERIC_CONN_PARAM, \
                            TIWdgGenericConnParamClass))
#define TI_IS_WDG_GENERIC_CONN_PARAM(object) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_WDG_GENERIC_CONN_PARAM))
#define TI_IS_WDG_GENERIC_CONN_PARAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_WDG_GENERIC_CONN_PARAM))
#define TI_WDG_GENERIC_CONN_PARAM_GET_CLASS(object) \
  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_WDG_GENERIC_CONN_PARAM, \
                              TIWdgGenericConnParamClass))

struct _TIWdgGenericConnParam {
    TIWdgConnParam parent;
    gchar *type_sig;
};

GType ti_wdg_generic_conn_param_get_type (void);

/**
 * Creates a new TIWdgGenericConnParam
 *
 * @param name Parameter name
 * @param def_val Default value
 * @param type_sig D-Bus' type signature
 */
TIWdgConnParam *ti_wdg_generic_conn_param_new (const gchar *name,
    const gchar *def_val, const gchar *type_sig);

#endif
