########################################################################
#
#   Given a directory with TryeType fonts, generate a directory 
#   called 'derived ' with material to support the files from GhostScript. 
#   Generate pfb files for ghostscript and use the ttf files for X11.
#
#   The approach may sound strange, but the hard facts of every day 
#   life impose some compromises:
#   -   Many X11 servers suffer a lot from the pfb fonts made by 
#       ttf2pt1: They are too complicated.
#   -   The afm files created by ttf2pt1 are not always correct.
#       At least the Lucida*.ttf fonts that come with the Sun jre are not 
#	handled correctly.
#   -   The standard ghostscript pf2afm utility is confused by the 
#       fonts produced by ttf2pt1
#   -   The ttf files are better for X11, the pfb files are better 
#	for ps2pdf as it is called from rtf2pdf. In many cases, the 
#	fonts in the pdf file have bad quality if they come from 
#	ttf fonts.
#
#   Include derived/fonts.dir.extra in the regular fonts.dir file 
#   as it is used by X11. Make Teds Ted.ghostscriptFontToXmapping 
#   property refer to another mapping file that contains the strips 
#   from derived/fonts.dir.ted.extra. In this way, GhostScript will 
#   use the pfb files and Ted will ask X11 for the fonts that come 
#   from the ttf files.
#
#   This example uses the ttf2pt1 utility that can be downloaded from 
#   http://ttf2pt1.sourceforge.net. I do not suggest that it is always 
#   legal to convert fonts from ttf to PostScript format.
#
#   This is an example that is part of the Ted word processor installation.
#   Do not run this script before you know exactly what it does.
#   In particular, realise that it destroys any directory or file 
#   called 'derived' in the current directory.
#   Refer to http://www.nllgg.nl/Ted/index.html for the 'Ted' documentation.
#
########################################################################

rm -rf derived
mkdir derived
rm -rf derived
mkdir derived

for ttf in *.ttf
do
    fnt=`basename $ttf .ttf`
    afm=$fnt.afm
    pfb=$fnt.pfb

    ttf2pt1 -a -b $ttf derived/$fnt
    mv derived/$afm derived/$afm-wrong

    #Is confused by the font
    #pf2afm derived/$pfb

    Ted --TtfToAfm $ttf derived/$afm

    Ted --AfmToXFontsDir derived/$afm - | \
		sed -e "s/FontFileName/$ttf/" >> derived/fonts.dir.extra
    Ted --AfmToXFontsDir derived/$afm - | \
		sed -e "s/FontFileName/$pfb/" >> derived/fonts.dir.ted.extra

    Ted --AfmToGSFontmap derived/$afm - | \
		sed -e "s/FontFileName/$pfb/" >> derived/Fontmap.extra
done

echo '###########' Generated files:
du -a derived
