/***************************************************************************
 *   Copyright (C) 2007-2010 by Peter Semiletov                            *
 *   peter.semiletov@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "shortcuts.h"
#include "utils.h"


CShortcuts::CShortcuts (QWidget *widget)
{
  w = widget;
}


void CShortcuts::captions_iterate()
{
  captions.clear();
  QList <QAction *> a = w->findChildren <QAction *>();
    
  foreach (QAction *ac, a)  
          if (! ac->text().isEmpty())
             captions.prepend (ac->text());

  captions.sort();
}


QAction* CShortcuts::find_by_caption (const QString &text)
{
  QList<QAction *> a = w->findChildren<QAction *>();
  
  foreach (QAction *ac, a)  
          if (ac->text() == text)
             return ac;
 
  return NULL;
}


QAction* CShortcuts::find_by_shortcut (const QString &shcut)
{
  QList<QAction *> a = w->findChildren<QAction *>();

  foreach (QAction *ac, a)  
         if (ac->shortcut().toString() == shcut)
            return ac;
  
  return NULL;
}


QKeySequence CShortcuts::find_seq_by_caption (const QString &text)
{
  QAction *a = find_by_caption (text);

  if (a)
     return a->shortcut();

  return QKeySequence::fromString ("Ctrl+Alt+Z");
}


void CShortcuts::set_new_shortcut (const QString &menuitem, const QString &shcut)
{
  QAction *b = find_by_shortcut (shcut);
  if (b)
     b->setShortcut (QKeySequence(""));

  QAction *a = find_by_caption (menuitem);
  if (a)
     a->setShortcut (QKeySequence (shcut));
}


void CShortcuts::save_to_file (const QString &file_name)
{
  QList<QAction *> a = w->findChildren<QAction *>();
  QString s;

  foreach (QAction *ac, a)
       if (! ac->shortcut().toString().isEmpty())
          s.append (ac->text()).append ("=").append (ac->shortcut().toString()).append ("\n");
                 
  qstring_save (file_name, s);
}


void CShortcuts::load_from_file (const QString &file_name)
{
  if (! file_exists (file_name))
     return;

  QHash <QString, QString> hash = hash_load_keyval (file_name);

  QList<QAction *> a = w->findChildren<QAction *>();

  foreach (QAction *ac, a)
          if (hash.contains (ac->text()))
             {
              if (ac->shortcut().isEmpty())
                  ac->setShortcut (QKeySequence (hash.value (ac->text())));
             }
}


void CShortcutEntry::keyPressEvent (QKeyEvent *event)
{
  event->accept();
  setText (mod_to_string (event->modifiers()) + keycode_to_string (event->key()));
}
