'\"
'\" Copyright (c) 1990-1992 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH update n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
update \- Process pending events and idle callbacks
.SH SYNOPSIS
\fBupdate\fR ?\fBidletasks\fR?
.BE
.SH DESCRIPTION
.PP
This command is used to bring the application
.QW "up to date"
by entering the event loop repeatedly until all pending events
(including idle callbacks) have been processed.
.PP
If the \fBidletasks\fR keyword is specified as an argument to the
command, then no new events or errors are processed;  only idle
callbacks are invoked.
This causes operations that are normally deferred, such as display
updates and window layout calculations, to be performed immediately.
.PP
The \fBupdate idletasks\fR command is useful in scripts where
changes have been made to the application's state and you want those
changes to appear on the display immediately, rather than waiting
for the script to complete.  Most display updates are performed as
idle callbacks, so \fBupdate idletasks\fR will cause them to run.
However, there are some kinds of updates that only happen in
response to events, such as those triggered by window size changes;
these updates will not occur in \fBupdate idletasks\fR.
.PP
The \fBupdate\fR command with no options is useful in scripts where
you are performing a long-running computation but you still want
the application to respond to events such as user interactions;  if
you occasionally call \fBupdate\fR then user input will be processed
during the next call to \fBupdate\fR.
.SH EXAMPLE
.PP
Run computations for about a second and then finish:
.PP
.CS
set x 1000
set done 0
after 1000 set done 1
while {!$done} {
    # A very silly example!
    set x [expr {log($x) ** 2.8}]

    # Test to see if our time-limit has been hit.  This would
    # also give a chance for serving network sockets and, if
    # the Tk package is loaded, updating a user interface.
    \fBupdate\fR
}
.CE
.SH "SEE ALSO"
after(n), interp(n)
.SH KEYWORDS
asynchronous I/O, event, flush, handler, idle, update
