/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/input/filter.cc
 */

#ifndef COMMON_TAR_INPUT_FILTER_H
#define COMMON_TAR_INPUT_FILTER_H

#include <tar/input.h>

/**
  * The tar_input_filter class is used to represent the state of an
  * input filter.  It remembers the origin of the input, and implements
  * transparent methods by default.  Specific filters will want to
  * override some or all of these defaults.
  */
class tar_input_filter:
    public tar_input
{
public:
     /**
       * The destructor.
       */
     virtual ~tar_input_filter();

     // See base class for documentation.
     virtual int read_data(void *, int);

     // See base class for documentation.
     virtual void read_data_padding();

     // See base class for documentation.
     virtual int read_header(tar_header &);

     // See base class for documentation.
     virtual void read_header_padding();

     // See base class for documentation.
     virtual const char *filename() const;

protected:
     /**
       * The constructor.  Derived classes shall pass the deeper file
       * reference.
       */
     tar_input_filter(tar_input *);

private:
     tar_input *fp;

     /**
       * Default constructor.  Do not use.
       */
     tar_input_filter();

     /**
       * Copy constructor.  Do not use.
       */
     tar_input_filter(const tar_input_filter &);

     /**
       * Assignment operator.  Do not use.
       */
     tar_input_filter &operator = (const tar_input_filter &);
};

#endif /* COMMON_TAR_INPUT_FILTER_H */
