/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar inputs
 */

#include <ac/stdio.h>

#include <error.h>
#include <tar/input.h>


tar_input::tar_input()
{
}


tar_input::~tar_input()
{
}


void
tar_input::fatal(char *fmt, ...)
	const
{
	va_list ap;
	va_start(ap, fmt);
	char buffer[2000];
	vsnprintf(buffer, sizeof(buffer), fmt, ap);
	va_end(ap);
	const char *s = filename();
	::fatal("%s: %s", s, buffer);
}


void
tar_input::warning(char *fmt, ...)
	const
{
	va_list ap;
	va_start(ap, fmt);
	char buffer[2000];
	vsnprintf(buffer, sizeof(buffer), fmt, ap);
	va_end(ap);
	const char *s = filename();
	::error("%s: warning: %s", s, buffer);
}


void
tar_input::read_data_padding()
{
	/* default is none */
}


void
tar_input::read_header_padding()
{
	read_data_padding();
}
