/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1995, 1998, 1999, 2001, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate prognames
 */

#include <ac/assert.h>
#include <ac/string.h>

#include <progname.h>

static const char *progname;


const char *
progname_get(void)
{
	return (progname ? progname : "");
}


void
progname_set(char *s)
{
	/* do NOT put tracing in this function */
	assert(s);
	assert(!progname);
	char *tmp = s;
	for (;;)
	{
		tmp = strrchr(s, '/');

		/*
		 * we were invoked as
		 *	progname -args
		 */
		if (!tmp)
		{
			tmp = s;
			break;
		}

		/*
		 * we were invoked as
		 *	/usr/local/progname -args
		 */
		if (tmp[1])
		{
			++tmp;
			break;
		}

		/*
		 * this is real nasty:
		 * it is possible to invoke us as
		 *	/usr//local///bin////progname///// -args
		 * and it is legal!!
		 */
		*tmp = 0;
	}
	progname = tmp;
}
