/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tapioca/tpa-base.h>
#include <tapioca/tpa-client.h>

#include <glib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <signal.h>
#include <sys/types.h>

/* variables */
static GMainLoop *mainloop;
static TpaManagerFactory *factory;
static TpaManager *manager;

int main (int argc, char **argv)
{
    g_type_init ();
    mainloop = g_main_loop_new (NULL, FALSE);

    tpa_debug_set_flags_from_env ();

    g_setenv ("TELEPATHY_DATA_PATH", ".", FALSE);

    factory = tpa_manager_factory_new ();
    if (factory) {
        GPtrArray *tmp = NULL;
        guint i = 0;

        tmp = tpa_manager_factory_get_all_managers (factory);
        g_print ("Managers available:\n");
        for (i = 0; i < tmp->len; i++)
            g_print ("%s\n", tpa_manager_get_name (g_ptr_array_index (tmp, i)));

        tmp = tpa_manager_factory_get_all_profiles (factory);
        for (i = 0; i < tmp->len; i++) {
            gchar *name = g_ptr_array_index (tmp, i);

            g_print ("Profile %s\n", name);

            manager = tpa_manager_factory_get_manager (factory, name);
            if (manager) {
                guint j = 0;
                TpaProfile *profile =
                    tpa_manager_get_profile (manager, name);
                GPtrArray *tmp2 = tpa_profile_get_all_parameters (profile);
                for (j = 0; j < tmp2->len; j++) {
                    TpaParameter *parameter = g_ptr_array_index (tmp2, j);

                    if (tpa_parameter_has_default_flag (parameter)) {
                            g_print ("Parameter %s=%s\n", tpa_parameter_get_name (parameter),
                                tpa_parameter_get_default_value_as_string (parameter));
                    }
                    else
                        g_print ("Parameter %s\n", tpa_parameter_get_name (parameter));
                }
                g_ptr_array_free (tmp2, FALSE);
                g_object_unref (manager);
            }
        }

        g_ptr_array_free (tmp, FALSE);
        tpa_manager_factory_reload (factory);
        g_object_unref (factory);
    }

    return 0;
}
