/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_SESSION_H__
#define __TPA_SESSION_H__

#include <dbus/dbus-glib.h>
#include <glib-object.h>

#include "tpa-account.h"
#include "tpa-channel.h"
#include "tpa-text.h"
#include "tpa-room-list.h"
#include "tpa-media.h"
#include "tpa-group.h"
#include "tpa-handle.h"
#include "tpa-ice.h"

#include <tapioca/base/tpa-enums.h>
#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaSession TpaSession;
typedef struct _TpaSessionClass TpaSessionClass;
typedef struct _TpaSessionPrivate TpaSessionPrivate;

typedef struct _TpaSession TpaTextSession;
typedef struct _TpaSession TpaMediaSession;

struct _TpaSessionClass {
    GObjectClass parent_class;
};

struct _TpaSession {
    GObject parent;

    TpaAccount *account;

    TpaSessionPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_SESSION \
    (tpa_session_get_type())
#define TPA_SESSION(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_SESSION, TpaSession))
#define TPA_SESSION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_SESSION, TpaSessionClass))
#define TPA_IS_SESSION(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_SESSION))
#define TPA_IS_SESSION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_SESSION))
#define TPA_SESSION_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_SESSION, TpaSessionClass))


GType       tpa_session_get_type                (void);
TpaSession* tpa_session_new                     (GType object_type,
                                                 TpaAccount *account,
                                                 TpaChannelType type,
                                                 TpaHandle *handle,
                                                 const gchar *manager,
                                                 const gchar *name);
void        tpa_session_unref                   (TpaSession *self);
#define     tpa_text_session_new(object_typ, connection, handle, manager, name) \
    (tpa_session_new (object_typ, connection, TPA_CHANNEL_TYPE_TEXT, handle, manager, name))
#define     tpa_media_session_new(object_typ, connection, handle, manager, name) \
    (tpa_session_new (object_typ, connection, TPA_CHANNEL_TYPE_STREAMEDMEDIA, handle, manager, name))
gboolean    tpa_session_register                (TpaSession *self,
                                                 const gchar *manager,
                                                 const gchar *name);
void        tpa_session_list                    (TpaSession *self,
                                                 GPtrArray *list);

G_END_DECLS

#endif /* #ifndef __TPA_SESSION_H_*/
