/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONNECTION_H__
#define __TPA_CONNECTION_H__

#include <dbus/dbus-glib.h>
#include <glib-object.h>

#include "tpa-handle.h"

#include <tapioca/base/tpa-errors.h>
#include <tapioca/base/tpa-enums.h>

G_BEGIN_DECLS

typedef struct _TpaIConnection TpaIConnection;

struct _TpaIConnection {
    GTypeInterface parent;

    /* Virtual Methods */
    TpaError    (* connect)                 (GObject *obj);
    TpaError    (* disconnect)              (GObject *obj);
    TpaError    (* get_self_handle)         (GObject *obj,
                                             guint *ret);
    TpaError    (* get_interfaces)          (GObject *obj,
                                             gchar ***ret);
    TpaError    (* hold_handles)            (GObject *obj,
                                             guint handle_type,
                                             const GArray *handles);
    TpaError     (* inspect_handles)        (GObject *obj,
                                             guint handle_type,
                                             const GArray *handles,
                                             gchar **ret);
    TpaError     (* format_string)          (GObject *obj,
                                             const gchar *string,
                                             gchar **ret);
    TpaError     (* release_handles)        (GObject *obj,
                                             guint handle_type,
                                             const GArray *handles);
    TpaError     (* request_session)        (GObject *obj,
                                             const gchar *type,
                                             const gchar *string,
                                             gboolean suppress_handler);
    TpaError     (* request_handles)        (GObject *obj,
                                             guint handle_type,
                                             const gchar **names);
    TpaConnectionStatus status;
    TpaConnectionStatusReason reason;
    TpaHandle *handle;
    GHashTable *handles;
    GPtrArray *sessions;
    gchar *protocol;
};

/* TYPE MACROS */
#define TPA_TYPE_ICONNECTION \
    (tpa_connection_get_type ())
#define TPA_IS_ICONNECTION(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_ICONNECTION))
#define TPA_ICONNECTION(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_ICONNECTION, TpaIConnection))

GType       tpa_connection_get_type             (void);
void        tpa_connection_init                 (TpaIConnection *iface,
                                                 gpointer data);
void        tpa_connection_finalize             (GObject *obj);
gchar*      tpa_connection_get_string           (GObject *obj,
                                                 guint handle);
TpaHandle*  tpa_connection_get_handle           (GObject *obj,
                                                 TpaConnectionHandleType type,
                                                 const gchar *string);
#define     tpa_connection_get_contact_handle(conn, string) \
    (tpa_connection_get_handle (conn, TPA_CONNECTION_HANDLE_TYPE_CONTACT, string))
#define     tpa_connection_get_list_handle(conn, string) \
    (tpa_connection_get_handle (conn, TPA_CONNECTION_HANDLE_TYPE_LIST, string))
#define     tpa_connection_get_room_handle(conn, string) \
    (tpa_connection_get_handle (conn, TPA_CONNECTION_HANDLE_TYPE_ROOM, string))
void        tpa_connection_signal_new_channel   (GObject *obj,
                                                 const gchar *obj_path,
                                                 TpaChannelType type,
                                                 const gchar *string,
                                                 gboolean suppress_handler);
void        tpa_connection_signal_status_changed
                                                (GObject *obj,
                                                 TpaConnectionStatus status,
                                                 TpaConnectionStatusReason reason);

G_END_DECLS

#endif /* #ifndef __TPA_CONNECTION_H__*/
