/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONNECTION_MANAGER_H__
#define __TPA_CONNECTION_MANAGER_H__

#include <glib-object.h>

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIConnectionManager TpaIConnectionManager;
typedef struct _TpaConnectionManagerParam TpaConnectionManagerParam;

struct _TpaIConnectionManager {
    GTypeInterface parent;

    /* Virtual Methods */
    TpaError    (* request_connection)      (GObject *obj,
                                             const gchar *protocol,
                                             GHashTable *parameters,
                                             gchar **name);
    GPtrArray *parameters;
    gchar **protocols;
    gchar *name;
};

struct _TpaConnectionManagerParam
{
    gchar *name;
    guint flag;
    gchar *type;
    gpointer value;
};

/* TYPE MACROS */
#define TPA_TYPE_ICONNECTION_MANAGER \
    (tpa_connection_manager_get_type ())
#define TPA_IS_ICONNECTION_MANAGER(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_ICONNECTION_MANAGER))
#define TPA_ICONNECTION_MANAGER(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_ICONNECTION_MANAGER, TpaIConnectionManager))

GType       tpa_connection_manager_get_type     (void);
void        tpa_connection_manager_init         (TpaIConnectionManager *iface,
                                                 gpointer data);
void        tpa_connection_manager_finalize     (GObject *obj);
void        tpa_connection_manager_signal_new_connection
                                                (GObject *obj,
                                                 const gchar *bus_name,
                                                 const gchar *obj_path,
                                                 const gchar *protocol);

G_END_DECLS

#endif /* #ifndef __TPA_CONNECTION_MANAGER_H__*/
