/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_ALIASING_H__
#define __TPA_ALIASING_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIAliasing TpaIAliasing;
typedef struct _TpaIAliasingPrivate TpaIAliasingPrivate;

struct _TpaIAliasing {
    GTypeInterface parent;

    TpaError    (* get_alias_flags)         (GObject *obj,
                                             guint *ret);
    TpaError    (* request_aliases)         (GObject *obj,
                                             const GArray *contacts,
                                             gchar ***ret);
    TpaError    (* set_aliases)             (GObject *obj,
                                             GHashTable *aliases);

    TpaIAliasingPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IALIASING \
    (tpa_aliasing_get_type ())
#define TPA_IS_IALIASING(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IALIASING))
#define TPA_IALIASING(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IALIASING, TpaIAliasing))

GType       tpa_aliasing_get_type               (void);
void        tpa_aliasing_init                   (TpaIAliasing *iface,
                                                 gpointer data);
void        tpa_aliasing_finalize               (GObject *obj);
void        tpa_aliasing_signal_aliases_changed (GObject *obj,
                                                 GPtrArray *aliases);

G_END_DECLS

#endif /* #ifndef __TPA_ALIASING_H__*/
