/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_ACCOUNT_H__
#define __TPA_ACCOUNT_H__

#include <dbus/dbus-glib.h>
#include <glib-object.h>

#include "tpa-manager.h"
#include "tpa-connection.h"
#include "tpa-aliasing.h"
#include "tpa-avatars.h"
#include "tpa-capabilities.h"
#include "tpa-contact-info.h"
#include "tpa-forwarding.h"
#include "tpa-handle.h"
#include "tpa-presence.h"
#include "tpa-properties.h"

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaAccount TpaAccount;
typedef struct _TpaAccountClass TpaAccountClass;
typedef struct _TpaAccountPrivate TpaAccountPrivate;

struct _TpaAccountClass {
    GObjectClass parent_class;
};

struct _TpaAccount {
    GObject parent;
    TpaManager *manager;

    TpaAccountPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_ACCOUNT \
  (tpa_account_get_type())
#define TPA_ACCOUNT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_ACCOUNT, TpaAccount))
#define TPA_ACCOUNT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_ACCOUNT, TpaAccountClass))
#define TPA_IS_ACCOUNT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_ACCOUNT))
#define TPA_IS_ACCOUNT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_ACCOUNT))
#define TPA_ACCOUNT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_ACCOUNT, TpaAccountClass))

GType       tpa_account_get_type                (void);
TpaAccount* tpa_account_new                     (GType object_type,
                                                 TpaManager *manager,
                                                 GHashTable *parameters,
                                                 const gchar *protocol,
                                                 const gchar *account);
void        tpa_account_unref                   (TpaAccount *self);
gboolean    tpa_account_register                (TpaAccount *self,
                                                 const gchar *manager,
                                                 const gchar *protocol,
                                                 const gchar *account);
void        tpa_account_add_session             (TpaAccount *self,
                                                 GObject *session);
void        tpa_account_remove_session          (TpaAccount *self,
                                                 GObject *session);

G_END_DECLS

#endif /* #ifndef __TPA_ACCOUNT_H__*/
