/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_PROFILE_H__
#define __TPA_PROFILE_H__

#include <glib.h>
#include <glib-object.h>

#include "tpa-parameter.h"

#include <tapioca/client/tpa-connection.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_PROFILE \
    (tpa_profile_get_type())
#define TPA_PROFILE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_PROFILE, TpaProfile))
#define TPA_PROFILE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_PROFILE, TpaProfileClass))
#define TPA_IS_PROFILE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_PROFILE))
#define TPA_IS_PROFILE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_PROFILE))
#define TPA_PROFILE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_PROFILE, TpaProfileClass))
#define TPA_PROFILE_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_PROFILE, TpaProfilePrivate))

typedef struct _TpaProfile TpaProfile;
typedef struct _TpaProfileClass TpaProfileClass;
typedef struct _TpaProfilePrivate TpaProfilePrivate;

struct _TpaProfileClass {
    GObjectClass parent_class;
};

struct _TpaProfile {
    GObject parent;
    TpaProfilePrivate *priv;
};

GType               tpa_profile_get_type                (void);
const gchar *       tpa_profile_get_protocol            (TpaProfile *self);
TpaParameter *      tpa_profile_get_parameter           (TpaProfile *self,
                                                         const gchar *name);
GPtrArray *         tpa_profile_get_all_parameters      (TpaProfile *self);
GPtrArray *         tpa_profile_get_mandatory_parameters(TpaProfile *self);
GPtrArray *         tpa_profile_get_registration_parameters
                                                        (TpaProfile *self);

G_END_DECLS

#endif /* #ifndef __TPA_PROFILE_H__*/
