/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_PARAMETER_H__
#define __TPA_PARAMETER_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-connection.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_PARAMETER \
    (tpa_parameter_get_type())
#define TPA_PARAMETER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_PARAMETER, TpaParameter))
#define TPA_PARAMETER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_PARAMETER, TpaParameterClass))
#define TPA_IS_PARAMETER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_PARAMETER))
#define TPA_IS_PARAMETER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_PARAMETER))
#define tpa_parameter_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_PARAMETER, TpaParameterClass))
#define TPA_PARAMETER_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_PARAMETER, TpaParameterPrivate))

typedef struct _TpaParameter TpaParameter;
typedef struct _TpaParameterClass TpaParameterClass;
typedef struct _TpaParameterPrivate TpaParameterPrivate;

struct _TpaParameterClass {
    GObjectClass parent_class;
};

struct _TpaParameter {
    GObject parent;
    TpaParameterPrivate *priv;
};

GType               tpa_parameter_get_type             (void);
TpaParameter *      tpa_parameter_new                  (const gchar *name,
                                                        GType type);
const gchar *       tpa_parameter_get_name             (TpaParameter *self);
GValue *            tpa_parameter_get_default_value    (TpaParameter *self);
gchar *             tpa_parameter_get_default_value_as_string
                                                        (TpaParameter *self);
guint               tpa_parameter_get_default_value_as_uint
                                                        (TpaParameter *self);
gint                tpa_parameter_get_default_value_as_int
                                                        (TpaParameter *self);
gboolean            tpa_parameter_get_default_value_as_boolean
                                                        (TpaParameter *self);
gboolean            tpa_parameter_set_default_value    (TpaParameter *self,
                                                         GValue *value);
gboolean            tpa_parameter_set_default_value_as_string
                                                        (TpaParameter *self,
                                                         const gchar *value_as_string);
gboolean            tpa_parameter_set_default_value_as_uint
                                                        (TpaParameter *self,
                                                         guint value_as_uint);
gboolean            tpa_parameter_set_default_value_as_int
                                                        (TpaParameter *self,
                                                         gint value_as_int);
gboolean            tpa_parameter_set_default_value_as_boolean
                                                        (TpaParameter *self,
                                                         gboolean value_as_boolean);
GValue *            tpa_parameter_get_value            (TpaParameter *self);
gchar *             tpa_parameter_get_value_as_string  (TpaParameter *self);
guint               tpa_parameter_get_value_as_uint    (TpaParameter *self);
gint                tpa_parameter_get_value_as_int     (TpaParameter *self);
gboolean            tpa_parameter_get_value_as_boolean (TpaParameter *self);
gboolean            tpa_parameter_set_value            (TpaParameter *self,
                                                        GValue *value);
gboolean            tpa_parameter_set_value_as_string  (TpaParameter *self,
                                                        const gchar *value_as_string);
gboolean            tpa_parameter_set_value_as_uint    (TpaParameter *self,
                                                        guint value_as_uint);
gboolean            tpa_parameter_set_value_as_int     (TpaParameter *self,
                                                        gint value_as_int);
gboolean            tpa_parameter_set_value_as_boolean (TpaParameter *self,
                                                        gboolean value_as_boolen);
//void                tpa_parameter_reset                (TpaParameter *self);
TpaParameterFlags   tpa_parameter_get_flags            (TpaParameter *self);
#define             tpa_parameter_has_required_flag(self) \
    (tpa_parameter_get_flags (self) & TPA_PARAMETER_FLAGS_REQUIRED)
#define             tpa_parameter_has_register_flag(self) \
    (tpa_parameter_get_flags (self) & TPA_PARAMETER_FLAGS_REGISTER)
#define             tpa_parameter_has_default_flag(self) \
    (tpa_parameter_get_flags (self) & TPA_PARAMETER_FLAGS_DEFAULT)
gboolean            tpa_parameter_set_flags            (TpaParameter *self,
                                                        TpaParameterFlags flags);
#define             tpa_parameter_set_required_flag(self) \
    (tpa_parameter_set_flags (self, TPA_PARAMETER_FLAGS_REQUIRED))
#define             tpa_parameter_set_register_flag(self) \
    (tpa_parameter_set_flags (self, TPA_PARAMETER_FLAGS_REGISTER))
#define             tpa_parameter_set_default_flag(self) \
    (tpa_parameter_set_flags (self, TPA_PARAMETER_FLAGS_DEFAULT))

G_END_DECLS

#endif /* #ifndef __TPA_PARAMETER_H__*/
