/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_MANAGER_H__
#define __TPA_MANAGER_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-profile.h>
#include <tapioca/client/tpa-connection.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_MANAGER \
    (tpa_manager_get_type())
#define TPA_MANAGER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_MANAGER, TpaManager))
#define TPA_MANAGER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_MANAGER, TpaManagerClass))
#define TPA_IS_MANAGER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_MANAGER))
#define TPA_IS_MANAGER_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_MANAGER))
#define TPA_MANAGER_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_MANAGER, TpaManagerClass))
#define TPA_MANAGER_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_MANAGER, TpaManagerPrivate))

typedef struct _TpaManager TpaManager;
typedef struct _TpaManagerClass TpaManagerClass;
typedef struct _TpaManagerPrivate TpaManagerPrivate;

struct _TpaManagerClass {
    TpaObjectClass parent_class;
};

struct _TpaManager {
    TpaObject parent;
    TpaManagerPrivate *priv;
};

GType               tpa_manager_get_type                (void);
gchar *             tpa_manager_get_name                (TpaManager *self);
GPtrArray *         tpa_manager_get_supported_profiles  (TpaManager *self);
GPtrArray *         tpa_manager_get_connections         (TpaManager *self);
TpaProfile *        tpa_manager_get_profile             (TpaManager *self,
                                                         const gchar *profile);
gboolean            tpa_manager_is_running              (TpaManager *self);
TpaConnection *     tpa_manager_request_connection      (TpaManager *self,
                                                         TpaProfile *profile);
gboolean            tpa_manager_supports                (TpaManager *self,
                                                         const gchar *profile);
G_END_DECLS

#endif /* #ifndef __TPA_MANAGER_H__*/
