/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 * @author  Marcio Macedo <marcio.macedo@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONNECTION_H__
#define __TPA_CONNECTION_H__

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>

#include <tapioca/client/tpa-channel-target.h>
#include <tapioca/client/tpa-contact-list.h>
#include <tapioca/client/tpa-user-contact.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_CONNECTION \
  (tpa_connection_get_type())
#define TPA_CONNECTION(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_CONNECTION, TpaConnection))
#define TPA_CONNECTION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_CONNECTION, TpaConnectionClass))
#define TPA_IS_CONNECTION(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_CONNECTION))
#define TPA_IS_CONNECTION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_CONNECTION))
#define TPA_CONNECTION_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_CONNECTION, TpaConnectionClass))
#define TPA_CONNECTION_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_CONNECTION, TpaConnectionPrivate))

typedef struct _TpaConnection TpaConnection;
typedef struct _TpaConnectionClass TpaConnectionClass;
typedef struct _TpaConnectionPrivate TpaConnectionPrivate;

struct _TpaConnectionClass {
    TpaObjectClass parent_class;
};

struct _TpaConnection {
    TpaObject parent;
    TpaConnectionPrivate *priv;
};

GType               tpa_connection_get_type             (void);
const gchar *       tpa_connection_get_protocol         (TpaConnection *self);
void                tpa_connection_connect              (TpaConnection *self);
void                tpa_connection_disconnect           (TpaConnection *self);
void                tpa_connection_create_channel       (TpaConnection *self,
                                                         TpaChannelType type,
                                                         TpaChannelTarget *target);
TpaConnectionStatus tpa_connection_get_status           (TpaConnection *self);
TpaContactList *    tpa_connection_get_contactlist      (TpaConnection *self);

GPtrArray *         tpa_connection_get_open_channels    (TpaConnection *self);
TpaUserContact *    tpa_connection_get_user_contact     (TpaConnection *self);

G_END_DECLS

#endif /* #ifndef __TPA_CONNECTION_H__*/
