/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CHANNEL_TARGET_H__
#define __TPA_CHANNEL_TARGET_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-object.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_CHANNEL_TARGET \
    (tpa_channel_target_get_type())
#define TPA_CHANNEL_TARGET(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_CHANNEL_TARGET, TpaChannelTarget))
#define TPA_CHANNEL_TARGET_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_CHANNEL_TARGET, TpaChannelTargetClass))
#define TPA_IS_CHANNEL_TARGET(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_CHANNEL_TARGET))
#define TPA_IS_CHANNEL_TARGET_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_CHANNEL_TARGET))
#define TPA_CHANNEL_TARGET_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_CHANNEL_TARGET, TpaChannelTargetClass))
#define TPA_CHANNEL_TARGET_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_CHANNEL_TARGET, TpaChannelTargetPrivate))


typedef struct _TpaChannelTarget TpaChannelTarget;
typedef struct _TpaChannelTargetClass TpaChannelTargetClass;
typedef struct _TpaChannelTargetPrivate TpaChannelTargetPrivate;

struct _TpaChannelTargetClass {
    TpaObjectClass parent_class;
};

struct _TpaChannelTarget {
    TpaObject parent;
    TpaChannelTargetPrivate *priv;
};

GType               tpa_channel_target_get_type         (void);
const gchar *       tpa_channel_target_get_uri          (TpaChannelTarget *self);

G_END_DECLS

#endif /* #ifndef __TPA_CHANNEL_TARGET_H__*/
