/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "tpa-utils.h"

#include <glib.h>
#include <string.h>

TpaChannelType
tpa_utils_get_channel_type_as_enum (const gchar *interface)
{
    gchar *type;
    TpaChannelType ret = -1;

    g_return_val_if_fail (interface != NULL, -1);

    type = g_strrstr (interface, ".");

    ++type;

    if (type) {
        if (g_ascii_strncasecmp (type, "ContactList", strlen (type)) == 0)
            ret = TPA_CHANNEL_TYPE_CONTACTLIST;
        else if (g_ascii_strncasecmp (type, "ContactSearch", strlen (type)) == 0)
            ret = TPA_CHANNEL_TYPE_CONTACTSEARCH;
        else if (g_ascii_strncasecmp (type, "StreamedMedia", strlen (type)) == 0)
            ret = TPA_CHANNEL_TYPE_STREAMEDMEDIA;
        else if (g_ascii_strncasecmp (type, "RoomList", strlen (type)) == 0)
            ret = TPA_CHANNEL_TYPE_ROOMLIST;
        else if (g_ascii_strncasecmp (type, "Text", strlen (type)) == 0)
            ret = TPA_CHANNEL_TYPE_TEXT;
    }
    return ret;
}

const gchar *
tpa_utils_get_channel_type_as_string (TpaChannelType type)
{
    gchar *iface = NULL;

    if (type == TPA_CHANNEL_TYPE_CONTACTLIST)
        iface = g_strdup ("org.freedesktop.Telepathy.Channel.Type.ContactList");
    else if (type == TPA_CHANNEL_TYPE_CONTACTSEARCH)
        iface = g_strdup ("org.freedesktop.Telepathy.Channel.Type.ContactSearch");
    else if (type == TPA_CHANNEL_TYPE_STREAMEDMEDIA)
        iface = g_strdup ("org.freedesktop.Telepathy.Channel.Type.StreamedMedia");
    else if (type == TPA_CHANNEL_TYPE_ROOMLIST)
        iface = g_strdup ("org.freedesktop.Telepathy.Channel.Type.RoomList");
    else if (type == TPA_CHANNEL_TYPE_TEXT)
        iface = g_strdup ("org.freedesktop.Telepathy.Channel.Type.Text");

    return iface;
}

TpaConnectionHandleType
tpa_utils_get_handle_type_by_channel_type (TpaChannelType type)
{
    TpaConnectionHandleType htype = TPA_CONNECTION_HANDLE_TYPE_NONE;

    if (type == TPA_CHANNEL_TYPE_CONTACTLIST)
        htype = TPA_CONNECTION_HANDLE_TYPE_LIST;
    else if (type == TPA_CHANNEL_TYPE_CONTACTSEARCH)
        htype = TPA_CONNECTION_HANDLE_TYPE_LIST;
    else if (type == TPA_CHANNEL_TYPE_STREAMEDMEDIA)
        htype = TPA_CONNECTION_HANDLE_TYPE_CONTACT;
    else if (type == TPA_CHANNEL_TYPE_ROOMLIST)
        htype = TPA_CONNECTION_HANDLE_TYPE_ROOM;
    else if (type == TPA_CHANNEL_TYPE_TEXT)
        htype = TPA_CONNECTION_HANDLE_TYPE_CONTACT;

    return htype;
}
