// This file is generated by omniidl (C++ backend)- omniORB_4_1. Do not edit.
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//

#include "tango.h"
#include <omniORB4/IOP_S.h>
#include <omniORB4/IOP_C.h>
#include <omniORB4/callDescriptor.h>
#include <omniORB4/callHandle.h>
#include <omniORB4/objTracker.h>


OMNI_USING_NAMESPACE(omni)

static const char* _0RL_library_version = omniORB_4_1;



void
Tango::DevVarLongStringArray::operator>>= (cdrStream &_n) const
{
  (const DevVarLongArray&) lvalue >>= _n;
  (const DevVarStringArray&) svalue >>= _n;

}

void
Tango::DevVarLongStringArray::operator<<= (cdrStream &_n)
{
  (DevVarLongArray&)lvalue <<= _n;
  (DevVarStringArray&)svalue <<= _n;

}

void
Tango::DevVarDoubleStringArray::operator>>= (cdrStream &_n) const
{
  (const DevVarDoubleArray&) dvalue >>= _n;
  (const DevVarStringArray&) svalue >>= _n;

}

void
Tango::DevVarDoubleStringArray::operator<<= (cdrStream &_n)
{
  (DevVarDoubleArray&)dvalue <<= _n;
  (DevVarStringArray&)svalue <<= _n;

}

void
Tango::DevEncoded::operator>>= (cdrStream &_n) const
{
  _n.marshalString(encoded_format,0);
  (const DevVarCharArray&) encoded_data >>= _n;

}

void
Tango::DevEncoded::operator<<= (cdrStream &_n)
{
  encoded_format = _n.unmarshalString(0);
  (DevVarCharArray&)encoded_data <<= _n;

}

void
Tango::JavaClntIdent::operator>>= (cdrStream &_n) const
{
  _n.marshalString(MainClass,0);
  if (! _n.marshal_byte_swap()) {
    _n.put_octet_array((_CORBA_Octet*)(uuid),16,omni::ALIGN_8);
  }
  else 
  {
    _n.declareArrayLength(omni::ALIGN_8, 16);
    for (_CORBA_ULong _0i0 = 0; _0i0 < 2; _0i0++){
      uuid[_0i0] >>= _n;
    }
  }

}

void
Tango::JavaClntIdent::operator<<= (cdrStream &_n)
{
  MainClass = _n.unmarshalString(0);
  _n.unmarshalArrayULongLong((_CORBA_ULongLong*)(uuid), 2);

}

void
Tango::ClntIdent::operator>>= (cdrStream& _n) const
{
  _pd__d >>= _n;

  switch(_pd__d) {
    case CPP:
      _pd_cpp_clnt >>= _n;
      break;
    case JAVA:
      (const JavaClntIdent&) _pd_java_clnt >>= _n;
      break;
    default: break;

  
  }


}

void
Tango::ClntIdent::operator<<= (cdrStream& _n)
{
  (LockerLanguage&)_pd__d <<= _n;

  switch(_pd__d) {
    case CPP:
      _pd__default = 0;
      (CppClntIdent&)_pd_cpp_clnt <<= _n;
      break;
    case JAVA:
      _pd__default = 0;
      (JavaClntIdent&)_pd_java_clnt <<= _n;
      break;

  }
  _pd__initialised = 1;
}

void
Tango::TimeVal::operator>>= (cdrStream &_n) const
{
  tv_sec >>= _n;
  tv_usec >>= _n;
  tv_nsec >>= _n;

}

void
Tango::TimeVal::operator<<= (cdrStream &_n)
{
  (::CORBA::Long&)tv_sec <<= _n;
  (::CORBA::Long&)tv_usec <<= _n;
  (::CORBA::Long&)tv_nsec <<= _n;

}

void
Tango::DevCmdInfo::operator>>= (cdrStream &_n) const
{
  _n.marshalString(cmd_name,0);
  cmd_tag >>= _n;
  in_type >>= _n;
  out_type >>= _n;
  _n.marshalString(in_type_desc,0);
  _n.marshalString(out_type_desc,0);

}

void
Tango::DevCmdInfo::operator<<= (cdrStream &_n)
{
  cmd_name = _n.unmarshalString(0);
  (::CORBA::Long&)cmd_tag <<= _n;
  (::CORBA::Long&)in_type <<= _n;
  (::CORBA::Long&)out_type <<= _n;
  in_type_desc = _n.unmarshalString(0);
  out_type_desc = _n.unmarshalString(0);

}

void
Tango::DevCmdInfo_2::operator>>= (cdrStream &_n) const
{
  _n.marshalString(cmd_name,0);
  level >>= _n;
  cmd_tag >>= _n;
  in_type >>= _n;
  out_type >>= _n;
  _n.marshalString(in_type_desc,0);
  _n.marshalString(out_type_desc,0);

}

void
Tango::DevCmdInfo_2::operator<<= (cdrStream &_n)
{
  cmd_name = _n.unmarshalString(0);
  (DispLevel&)level <<= _n;
  (::CORBA::Long&)cmd_tag <<= _n;
  (::CORBA::Long&)in_type <<= _n;
  (::CORBA::Long&)out_type <<= _n;
  in_type_desc = _n.unmarshalString(0);
  out_type_desc = _n.unmarshalString(0);

}

void
Tango::DevError::operator>>= (cdrStream &_n) const
{
  _n.marshalString(reason,0);
  severity >>= _n;
  _n.marshalString(desc,0);
  _n.marshalString(origin,0);

}

void
Tango::DevError::operator<<= (cdrStream &_n)
{
  reason = _n.unmarshalString(0);
  (ErrSeverity&)severity <<= _n;
  desc = _n.unmarshalString(0);
  origin = _n.unmarshalString(0);

}

void
Tango::NamedDevError::operator>>= (cdrStream &_n) const
{
  _n.marshalString(name,0);
  index_in_call >>= _n;
  (const DevErrorList&) err_list >>= _n;

}

void
Tango::NamedDevError::operator<<= (cdrStream &_n)
{
  name = _n.unmarshalString(0);
  (::CORBA::Long&)index_in_call <<= _n;
  (DevErrorList&)err_list <<= _n;

}

::CORBA::Exception::insertExceptionToAny Tango::DevFailed::insertToAnyFn = 0;
::CORBA::Exception::insertExceptionToAnyNCP Tango::DevFailed::insertToAnyFnNCP = 0;

Tango::DevFailed::DevFailed(const Tango::DevFailed& _s) : ::CORBA::UserException(_s)
{
  errors = _s.errors;

}

Tango::DevFailed::DevFailed(const DevErrorList _errors)
{
  pd_insertToAnyFn    = Tango::DevFailed::insertToAnyFn;
  pd_insertToAnyFnNCP = Tango::DevFailed::insertToAnyFnNCP;
  errors = _errors;

}



Tango::DevFailed& Tango::DevFailed::operator=(const Tango::DevFailed& _s)
{
  ((::CORBA::UserException*) this)->operator=(_s);
  errors = _s.errors;

  return *this;
}

Tango::DevFailed::~DevFailed() {}

void Tango::DevFailed::_raise() const { throw *this; }

const char* Tango::DevFailed::_PD_repoId = "IDL:Tango/DevFailed:1.0";
const char* Tango::DevFailed::_PD_typeId = "Exception/UserException/Tango::DevFailed";

Tango::DevFailed* Tango::DevFailed::_downcast(::CORBA::Exception* _e) {
  return (DevFailed*) _NP_is_a(_e, _PD_typeId);
}

const Tango::DevFailed* Tango::DevFailed::_downcast(const ::CORBA::Exception* _e) {
  return (const DevFailed*) _NP_is_a(_e, _PD_typeId);
}

::CORBA::Exception* Tango::DevFailed::_NP_duplicate() const {
  return new DevFailed(*this);
}

const char* Tango::DevFailed::_NP_typeId() const {
  return _PD_typeId;
}

const char* Tango::DevFailed::_NP_repoId(int* _size) const {
  *_size = sizeof("IDL:Tango/DevFailed:1.0");
  return _PD_repoId;
}
 
void Tango::DevFailed::_NP_marshal(cdrStream& _s) const {
  *this >>= _s;
}

void
Tango::DevFailed::operator>>= (cdrStream& _n) const
{
  (const DevErrorList&) errors >>= _n;

}

void
Tango::DevFailed::operator<<= (cdrStream& _n)
{
  (DevErrorList&)errors <<= _n;

}

::CORBA::Exception::insertExceptionToAny Tango::MultiDevFailed::insertToAnyFn = 0;
::CORBA::Exception::insertExceptionToAnyNCP Tango::MultiDevFailed::insertToAnyFnNCP = 0;

Tango::MultiDevFailed::MultiDevFailed(const Tango::MultiDevFailed& _s) : ::CORBA::UserException(_s)
{
  errors = _s.errors;

}

Tango::MultiDevFailed::MultiDevFailed(const NamedDevErrorList _errors)
{
  pd_insertToAnyFn    = Tango::MultiDevFailed::insertToAnyFn;
  pd_insertToAnyFnNCP = Tango::MultiDevFailed::insertToAnyFnNCP;
  errors = _errors;

}



Tango::MultiDevFailed& Tango::MultiDevFailed::operator=(const Tango::MultiDevFailed& _s)
{
  ((::CORBA::UserException*) this)->operator=(_s);
  errors = _s.errors;

  return *this;
}

Tango::MultiDevFailed::~MultiDevFailed() {}

void Tango::MultiDevFailed::_raise() const { throw *this; }

const char* Tango::MultiDevFailed::_PD_repoId = "IDL:Tango/MultiDevFailed:1.0";
const char* Tango::MultiDevFailed::_PD_typeId = "Exception/UserException/Tango::MultiDevFailed";

Tango::MultiDevFailed* Tango::MultiDevFailed::_downcast(::CORBA::Exception* _e) {
  return (MultiDevFailed*) _NP_is_a(_e, _PD_typeId);
}

const Tango::MultiDevFailed* Tango::MultiDevFailed::_downcast(const ::CORBA::Exception* _e) {
  return (const MultiDevFailed*) _NP_is_a(_e, _PD_typeId);
}

::CORBA::Exception* Tango::MultiDevFailed::_NP_duplicate() const {
  return new MultiDevFailed(*this);
}

const char* Tango::MultiDevFailed::_NP_typeId() const {
  return _PD_typeId;
}

const char* Tango::MultiDevFailed::_NP_repoId(int* _size) const {
  *_size = sizeof("IDL:Tango/MultiDevFailed:1.0");
  return _PD_repoId;
}
 
void Tango::MultiDevFailed::_NP_marshal(cdrStream& _s) const {
  *this >>= _s;
}

void
Tango::MultiDevFailed::operator>>= (cdrStream& _n) const
{
  (const NamedDevErrorList&) errors >>= _n;

}

void
Tango::MultiDevFailed::operator<<= (cdrStream& _n)
{
  (NamedDevErrorList&)errors <<= _n;

}

void
Tango::AttributeConfig::operator>>= (cdrStream &_n) const
{
  _n.marshalString(name,0);
  writable >>= _n;
  data_format >>= _n;
  data_type >>= _n;
  max_dim_x >>= _n;
  max_dim_y >>= _n;
  _n.marshalString(description,0);
  _n.marshalString(label,0);
  _n.marshalString(unit,0);
  _n.marshalString(standard_unit,0);
  _n.marshalString(display_unit,0);
  _n.marshalString(format,0);
  _n.marshalString(min_value,0);
  _n.marshalString(max_value,0);
  _n.marshalString(min_alarm,0);
  _n.marshalString(max_alarm,0);
  _n.marshalString(writable_attr_name,0);
  (const DevVarStringArray&) extensions >>= _n;

}

void
Tango::AttributeConfig::operator<<= (cdrStream &_n)
{
  name = _n.unmarshalString(0);
  (AttrWriteType&)writable <<= _n;
  (AttrDataFormat&)data_format <<= _n;
  (::CORBA::Long&)data_type <<= _n;
  (::CORBA::Long&)max_dim_x <<= _n;
  (::CORBA::Long&)max_dim_y <<= _n;
  description = _n.unmarshalString(0);
  label = _n.unmarshalString(0);
  unit = _n.unmarshalString(0);
  standard_unit = _n.unmarshalString(0);
  display_unit = _n.unmarshalString(0);
  format = _n.unmarshalString(0);
  min_value = _n.unmarshalString(0);
  max_value = _n.unmarshalString(0);
  min_alarm = _n.unmarshalString(0);
  max_alarm = _n.unmarshalString(0);
  writable_attr_name = _n.unmarshalString(0);
  (DevVarStringArray&)extensions <<= _n;

}

void
Tango::AttributeConfig_2::operator>>= (cdrStream &_n) const
{
  _n.marshalString(name,0);
  writable >>= _n;
  data_format >>= _n;
  data_type >>= _n;
  max_dim_x >>= _n;
  max_dim_y >>= _n;
  _n.marshalString(description,0);
  _n.marshalString(label,0);
  _n.marshalString(unit,0);
  _n.marshalString(standard_unit,0);
  _n.marshalString(display_unit,0);
  _n.marshalString(format,0);
  _n.marshalString(min_value,0);
  _n.marshalString(max_value,0);
  _n.marshalString(min_alarm,0);
  _n.marshalString(max_alarm,0);
  _n.marshalString(writable_attr_name,0);
  level >>= _n;
  (const DevVarStringArray&) extensions >>= _n;

}

void
Tango::AttributeConfig_2::operator<<= (cdrStream &_n)
{
  name = _n.unmarshalString(0);
  (AttrWriteType&)writable <<= _n;
  (AttrDataFormat&)data_format <<= _n;
  (::CORBA::Long&)data_type <<= _n;
  (::CORBA::Long&)max_dim_x <<= _n;
  (::CORBA::Long&)max_dim_y <<= _n;
  description = _n.unmarshalString(0);
  label = _n.unmarshalString(0);
  unit = _n.unmarshalString(0);
  standard_unit = _n.unmarshalString(0);
  display_unit = _n.unmarshalString(0);
  format = _n.unmarshalString(0);
  min_value = _n.unmarshalString(0);
  max_value = _n.unmarshalString(0);
  min_alarm = _n.unmarshalString(0);
  max_alarm = _n.unmarshalString(0);
  writable_attr_name = _n.unmarshalString(0);
  (DispLevel&)level <<= _n;
  (DevVarStringArray&)extensions <<= _n;

}

void
Tango::AttributeValue::operator>>= (cdrStream &_n) const
{
  (const ::CORBA::Any&) value >>= _n;
  quality >>= _n;
  (const TimeVal&) time >>= _n;
  _n.marshalString(name,0);
  dim_x >>= _n;
  dim_y >>= _n;

}

void
Tango::AttributeValue::operator<<= (cdrStream &_n)
{
  (::CORBA::Any&)value <<= _n;
  (AttrQuality&)quality <<= _n;
  (TimeVal&)time <<= _n;
  name = _n.unmarshalString(0);
  (::CORBA::Long&)dim_x <<= _n;
  (::CORBA::Long&)dim_y <<= _n;

}

void
Tango::AttributeDim::operator>>= (cdrStream &_n) const
{
  dim_x >>= _n;
  dim_y >>= _n;

}

void
Tango::AttributeDim::operator<<= (cdrStream &_n)
{
  (::CORBA::Long&)dim_x <<= _n;
  (::CORBA::Long&)dim_y <<= _n;

}

void
Tango::AttributeValue_3::operator>>= (cdrStream &_n) const
{
  (const ::CORBA::Any&) value >>= _n;
  quality >>= _n;
  (const TimeVal&) time >>= _n;
  _n.marshalString(name,0);
  (const AttributeDim&) r_dim >>= _n;
  (const AttributeDim&) w_dim >>= _n;
  (const DevErrorList&) err_list >>= _n;

}

void
Tango::AttributeValue_3::operator<<= (cdrStream &_n)
{
  (::CORBA::Any&)value <<= _n;
  (AttrQuality&)quality <<= _n;
  (TimeVal&)time <<= _n;
  name = _n.unmarshalString(0);
  (AttributeDim&)r_dim <<= _n;
  (AttributeDim&)w_dim <<= _n;
  (DevErrorList&)err_list <<= _n;

}

void
Tango::AttrValUnion::operator>>= (cdrStream& _n) const
{
  _pd__d >>= _n;

  switch(_pd__d) {
    case ATT_BOOL:
      (const DevVarBooleanArray&) _pd_bool_att_value >>= _n;
      break;
    case ATT_SHORT:
      (const DevVarShortArray&) _pd_short_att_value >>= _n;
      break;
    case ATT_LONG:
      (const DevVarLongArray&) _pd_long_att_value >>= _n;
      break;
    case ATT_LONG64:
      (const DevVarLong64Array&) _pd_long64_att_value >>= _n;
      break;
    case ATT_FLOAT:
      (const DevVarFloatArray&) _pd_float_att_value >>= _n;
      break;
    case ATT_DOUBLE:
      (const DevVarDoubleArray&) _pd_double_att_value >>= _n;
      break;
    case ATT_UCHAR:
      (const DevVarCharArray&) _pd_uchar_att_value >>= _n;
      break;
    case ATT_USHORT:
      (const DevVarUShortArray&) _pd_ushort_att_value >>= _n;
      break;
    case ATT_ULONG:
      (const DevVarULongArray&) _pd_ulong_att_value >>= _n;
      break;
    case ATT_ULONG64:
      (const DevVarULong64Array&) _pd_ulong64_att_value >>= _n;
      break;
    case ATT_STRING:
      (const DevVarStringArray&) _pd_string_att_value >>= _n;
      break;
    case ATT_STATE:
      (const DevVarStateArray&) _pd_state_att_value >>= _n;
      break;
    case DEVICE_STATE:
      _pd_dev_state_att >>= _n;
      break;
    case ATT_ENCODED:
      (const DevVarEncodedArray&) _pd_encoded_att_value >>= _n;
      break;
    case NO_DATA:
      _n.marshalBoolean(_pd_union_no_data);
      break;
    default: break;

  
  }


}

void
Tango::AttrValUnion::operator<<= (cdrStream& _n)
{
  (AttributeDataType&)_pd__d <<= _n;

  switch(_pd__d) {
    case ATT_BOOL:
      _pd__default = 0;
      (DevVarBooleanArray&)_pd_bool_att_value <<= _n;
      break;
    case ATT_SHORT:
      _pd__default = 0;
      (DevVarShortArray&)_pd_short_att_value <<= _n;
      break;
    case ATT_LONG:
      _pd__default = 0;
      (DevVarLongArray&)_pd_long_att_value <<= _n;
      break;
    case ATT_LONG64:
      _pd__default = 0;
      (DevVarLong64Array&)_pd_long64_att_value <<= _n;
      break;
    case ATT_FLOAT:
      _pd__default = 0;
      (DevVarFloatArray&)_pd_float_att_value <<= _n;
      break;
    case ATT_DOUBLE:
      _pd__default = 0;
      (DevVarDoubleArray&)_pd_double_att_value <<= _n;
      break;
    case ATT_UCHAR:
      _pd__default = 0;
      (DevVarCharArray&)_pd_uchar_att_value <<= _n;
      break;
    case ATT_USHORT:
      _pd__default = 0;
      (DevVarUShortArray&)_pd_ushort_att_value <<= _n;
      break;
    case ATT_ULONG:
      _pd__default = 0;
      (DevVarULongArray&)_pd_ulong_att_value <<= _n;
      break;
    case ATT_ULONG64:
      _pd__default = 0;
      (DevVarULong64Array&)_pd_ulong64_att_value <<= _n;
      break;
    case ATT_STRING:
      _pd__default = 0;
      (DevVarStringArray&)_pd_string_att_value <<= _n;
      break;
    case ATT_STATE:
      _pd__default = 0;
      (DevVarStateArray&)_pd_state_att_value <<= _n;
      break;
    case DEVICE_STATE:
      _pd__default = 0;
      (DevState&)_pd_dev_state_att <<= _n;
      break;
    case ATT_ENCODED:
      _pd__default = 0;
      (DevVarEncodedArray&)_pd_encoded_att_value <<= _n;
      break;
    case NO_DATA:
      _pd__default = 0;
      _pd_union_no_data = _n.unmarshalBoolean();
      break;

  }
  _pd__initialised = 1;
}

void
Tango::AttributeValue_4::operator>>= (cdrStream &_n) const
{
  (const AttrValUnion&) value >>= _n;
  quality >>= _n;
  data_format >>= _n;
  (const TimeVal&) time >>= _n;
  _n.marshalString(name,0);
  (const AttributeDim&) r_dim >>= _n;
  (const AttributeDim&) w_dim >>= _n;
  (const DevErrorList&) err_list >>= _n;

}

void
Tango::AttributeValue_4::operator<<= (cdrStream &_n)
{
  (AttrValUnion&)value <<= _n;
  (AttrQuality&)quality <<= _n;
  (AttrDataFormat&)data_format <<= _n;
  (TimeVal&)time <<= _n;
  name = _n.unmarshalString(0);
  (AttributeDim&)r_dim <<= _n;
  (AttributeDim&)w_dim <<= _n;
  (DevErrorList&)err_list <<= _n;

}

void
Tango::ChangeEventProp::operator>>= (cdrStream &_n) const
{
  _n.marshalString(rel_change,0);
  _n.marshalString(abs_change,0);
  (const DevVarStringArray&) extensions >>= _n;

}

void
Tango::ChangeEventProp::operator<<= (cdrStream &_n)
{
  rel_change = _n.unmarshalString(0);
  abs_change = _n.unmarshalString(0);
  (DevVarStringArray&)extensions <<= _n;

}

void
Tango::PeriodicEventProp::operator>>= (cdrStream &_n) const
{
  _n.marshalString(period,0);
  (const DevVarStringArray&) extensions >>= _n;

}

void
Tango::PeriodicEventProp::operator<<= (cdrStream &_n)
{
  period = _n.unmarshalString(0);
  (DevVarStringArray&)extensions <<= _n;

}

void
Tango::ArchiveEventProp::operator>>= (cdrStream &_n) const
{
  _n.marshalString(rel_change,0);
  _n.marshalString(abs_change,0);
  _n.marshalString(period,0);
  (const DevVarStringArray&) extensions >>= _n;

}

void
Tango::ArchiveEventProp::operator<<= (cdrStream &_n)
{
  rel_change = _n.unmarshalString(0);
  abs_change = _n.unmarshalString(0);
  period = _n.unmarshalString(0);
  (DevVarStringArray&)extensions <<= _n;

}

void
Tango::EventProperties::operator>>= (cdrStream &_n) const
{
  (const ChangeEventProp&) ch_event >>= _n;
  (const PeriodicEventProp&) per_event >>= _n;
  (const ArchiveEventProp&) arch_event >>= _n;

}

void
Tango::EventProperties::operator<<= (cdrStream &_n)
{
  (ChangeEventProp&)ch_event <<= _n;
  (PeriodicEventProp&)per_event <<= _n;
  (ArchiveEventProp&)arch_event <<= _n;

}

void
Tango::AttributeAlarm::operator>>= (cdrStream &_n) const
{
  _n.marshalString(min_alarm,0);
  _n.marshalString(max_alarm,0);
  _n.marshalString(min_warning,0);
  _n.marshalString(max_warning,0);
  _n.marshalString(delta_t,0);
  _n.marshalString(delta_val,0);
  (const DevVarStringArray&) extensions >>= _n;

}

void
Tango::AttributeAlarm::operator<<= (cdrStream &_n)
{
  min_alarm = _n.unmarshalString(0);
  max_alarm = _n.unmarshalString(0);
  min_warning = _n.unmarshalString(0);
  max_warning = _n.unmarshalString(0);
  delta_t = _n.unmarshalString(0);
  delta_val = _n.unmarshalString(0);
  (DevVarStringArray&)extensions <<= _n;

}

void
Tango::AttributeConfig_3::operator>>= (cdrStream &_n) const
{
  _n.marshalString(name,0);
  writable >>= _n;
  data_format >>= _n;
  data_type >>= _n;
  max_dim_x >>= _n;
  max_dim_y >>= _n;
  _n.marshalString(description,0);
  _n.marshalString(label,0);
  _n.marshalString(unit,0);
  _n.marshalString(standard_unit,0);
  _n.marshalString(display_unit,0);
  _n.marshalString(format,0);
  _n.marshalString(min_value,0);
  _n.marshalString(max_value,0);
  _n.marshalString(writable_attr_name,0);
  level >>= _n;
  (const AttributeAlarm&) att_alarm >>= _n;
  (const EventProperties&) event_prop >>= _n;
  (const DevVarStringArray&) extensions >>= _n;
  (const DevVarStringArray&) sys_extensions >>= _n;

}

void
Tango::AttributeConfig_3::operator<<= (cdrStream &_n)
{
  name = _n.unmarshalString(0);
  (AttrWriteType&)writable <<= _n;
  (AttrDataFormat&)data_format <<= _n;
  (::CORBA::Long&)data_type <<= _n;
  (::CORBA::Long&)max_dim_x <<= _n;
  (::CORBA::Long&)max_dim_y <<= _n;
  description = _n.unmarshalString(0);
  label = _n.unmarshalString(0);
  unit = _n.unmarshalString(0);
  standard_unit = _n.unmarshalString(0);
  display_unit = _n.unmarshalString(0);
  format = _n.unmarshalString(0);
  min_value = _n.unmarshalString(0);
  max_value = _n.unmarshalString(0);
  writable_attr_name = _n.unmarshalString(0);
  (DispLevel&)level <<= _n;
  (AttributeAlarm&)att_alarm <<= _n;
  (EventProperties&)event_prop <<= _n;
  (DevVarStringArray&)extensions <<= _n;
  (DevVarStringArray&)sys_extensions <<= _n;

}

void
Tango::AttDataReady::operator>>= (cdrStream &_n) const
{
  _n.marshalString(name,0);
  data_type >>= _n;
  ctr >>= _n;

}

void
Tango::AttDataReady::operator<<= (cdrStream &_n)
{
  name = _n.unmarshalString(0);
  (::CORBA::Long&)data_type <<= _n;
  (::CORBA::Long&)ctr <<= _n;

}

void
Tango::DevInfo::operator>>= (cdrStream &_n) const
{
  _n.marshalString(dev_class,0);
  _n.marshalString(server_id,0);
  _n.marshalString(server_host,0);
  server_version >>= _n;
  _n.marshalString(doc_url,0);

}

void
Tango::DevInfo::operator<<= (cdrStream &_n)
{
  dev_class = _n.unmarshalString(0);
  server_id = _n.unmarshalString(0);
  server_host = _n.unmarshalString(0);
  (::CORBA::Long&)server_version <<= _n;
  doc_url = _n.unmarshalString(0);

}

void
Tango::DevInfo_3::operator>>= (cdrStream &_n) const
{
  _n.marshalString(dev_class,0);
  _n.marshalString(server_id,0);
  _n.marshalString(server_host,0);
  server_version >>= _n;
  _n.marshalString(doc_url,0);
  _n.marshalString(dev_type,0);

}

void
Tango::DevInfo_3::operator<<= (cdrStream &_n)
{
  dev_class = _n.unmarshalString(0);
  server_id = _n.unmarshalString(0);
  server_host = _n.unmarshalString(0);
  (::CORBA::Long&)server_version <<= _n;
  doc_url = _n.unmarshalString(0);
  dev_type = _n.unmarshalString(0);

}

void
Tango::DevCmdHistory::operator>>= (cdrStream &_n) const
{
  (const TimeVal&) time >>= _n;
  _n.marshalBoolean(cmd_failed);
  (const ::CORBA::Any&) value >>= _n;
  (const DevErrorList&) errors >>= _n;

}

void
Tango::DevCmdHistory::operator<<= (cdrStream &_n)
{
  (TimeVal&)time <<= _n;
  cmd_failed = _n.unmarshalBoolean();
  (::CORBA::Any&)value <<= _n;
  (DevErrorList&)errors <<= _n;

}

void
Tango::DevAttrHistory::operator>>= (cdrStream &_n) const
{
  _n.marshalBoolean(attr_failed);
  (const AttributeValue&) value >>= _n;
  (const DevErrorList&) errors >>= _n;

}

void
Tango::DevAttrHistory::operator<<= (cdrStream &_n)
{
  attr_failed = _n.unmarshalBoolean();
  (AttributeValue&)value <<= _n;
  (DevErrorList&)errors <<= _n;

}

void
Tango::DevAttrHistory_3::operator>>= (cdrStream &_n) const
{
  _n.marshalBoolean(attr_failed);
  (const AttributeValue_3&) value >>= _n;

}

void
Tango::DevAttrHistory_3::operator<<= (cdrStream &_n)
{
  attr_failed = _n.unmarshalBoolean();
  (AttributeValue_3&)value <<= _n;

}

void
Tango::EltInArray::operator>>= (cdrStream &_n) const
{
  start >>= _n;
  nb_elt >>= _n;

}

void
Tango::EltInArray::operator<<= (cdrStream &_n)
{
  (::CORBA::Long&)start <<= _n;
  (::CORBA::Long&)nb_elt <<= _n;

}

void
Tango::DevAttrHistory_4::operator>>= (cdrStream &_n) const
{
  _n.marshalString(name,0);
  (const TimeValList&) dates >>= _n;
  (const ::CORBA::Any&) value >>= _n;
  (const AttrQualityList&) quals >>= _n;
  (const EltInArrayList&) quals_array >>= _n;
  (const AttributeDimList&) r_dims >>= _n;
  (const EltInArrayList&) r_dims_array >>= _n;
  (const AttributeDimList&) w_dims >>= _n;
  (const EltInArrayList&) w_dims_array >>= _n;
  (const DevErrorListList&) errors >>= _n;
  (const EltInArrayList&) errors_array >>= _n;

}

void
Tango::DevAttrHistory_4::operator<<= (cdrStream &_n)
{
  name = _n.unmarshalString(0);
  (TimeValList&)dates <<= _n;
  (::CORBA::Any&)value <<= _n;
  (AttrQualityList&)quals <<= _n;
  (EltInArrayList&)quals_array <<= _n;
  (AttributeDimList&)r_dims <<= _n;
  (EltInArrayList&)r_dims_array <<= _n;
  (AttributeDimList&)w_dims <<= _n;
  (EltInArrayList&)w_dims_array <<= _n;
  (DevErrorListList&)errors <<= _n;
  (EltInArrayList&)errors_array <<= _n;

}

void
Tango::DevCmdHistory_4::operator>>= (cdrStream &_n) const
{
  (const TimeValList&) dates >>= _n;
  (const ::CORBA::Any&) value >>= _n;
  (const AttributeDimList&) dims >>= _n;
  (const EltInArrayList&) dims_array >>= _n;
  (const DevErrorListList&) errors >>= _n;
  (const EltInArrayList&) errors_array >>= _n;
  cmd_type >>= _n;

}

void
Tango::DevCmdHistory_4::operator<<= (cdrStream &_n)
{
  (TimeValList&)dates <<= _n;
  (::CORBA::Any&)value <<= _n;
  (AttributeDimList&)dims <<= _n;
  (EltInArrayList&)dims_array <<= _n;
  (DevErrorListList&)errors <<= _n;
  (EltInArrayList&)errors_array <<= _n;
  (::CORBA::Long&)cmd_type <<= _n;

}

Tango::Device_ptr Tango::Device_Helper::_nil() {
  return ::Tango::Device::_nil();
}

::CORBA::Boolean Tango::Device_Helper::is_nil(::Tango::Device_ptr p) {
  return ::CORBA::is_nil(p);

}

void Tango::Device_Helper::release(::Tango::Device_ptr p) {
  ::CORBA::release(p);
}

void Tango::Device_Helper::marshalObjRef(::Tango::Device_ptr obj, cdrStream& s) {
  ::Tango::Device::_marshalObjRef(obj, s);
}

Tango::Device_ptr Tango::Device_Helper::unmarshalObjRef(cdrStream& s) {
  return ::Tango::Device::_unmarshalObjRef(s);
}

void Tango::Device_Helper::duplicate(::Tango::Device_ptr obj) {
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
}

Tango::Device_ptr
Tango::Device::_duplicate(::Tango::Device_ptr obj)
{
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
  return obj;
}

Tango::Device_ptr
Tango::Device::_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_realNarrow(_PD_repoId);
  return e ? e : _nil();
}


Tango::Device_ptr
Tango::Device::_unchecked_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_uncheckedNarrow(_PD_repoId);
  return e ? e : _nil();
}

Tango::Device_ptr
Tango::Device::_nil()
{
#ifdef OMNI_UNLOADABLE_STUBS
  static _objref_Device _the_nil_obj;
  return &_the_nil_obj;
#else
  static _objref_Device* _the_nil_ptr = 0;
  if( !_the_nil_ptr ) {
    omni::nilRefLock().lock();
    if( !_the_nil_ptr ) {
      _the_nil_ptr = new _objref_Device;
      registerNilCorbaObject(_the_nil_ptr);
    }
    omni::nilRefLock().unlock();
  }
  return _the_nil_ptr;
#endif
}

const char* Tango::Device::_PD_repoId = "IDL:Tango/Device:1.0";


Tango::_objref_Device::~_objref_Device() {
  
}


Tango::_objref_Device::_objref_Device(omniIOR* ior, omniIdentity* id) :
   omniObjRef(::Tango::Device::_PD_repoId, ior, id, 1)
   
   
{
  _PR_setobj(this);
}

void*
Tango::_objref_Device::_ptrToObjRef(const char* id)
{
  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::Device_ptr) this;
  
  if( id == ::CORBA::Object::_PD_repoId )
    return (::CORBA::Object_ptr) this;

  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::Device_ptr) this;
  
  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (::CORBA::Object_ptr) this;

  return 0;
}

// Proxy call descriptor class. Mangled signature:
//  _cany_i_cstring_i_cany_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_00000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_00000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Any_var arg_1_;
  const ::CORBA::Any* arg_1;
  ::CORBA::Any_var result;
};

void _0RL_cd_6fe2f94a21a10053_00000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  (const ::CORBA::Any&) *arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_00000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  arg_1_ = new ::CORBA::Any;
  (::CORBA::Any&)arg_1_ <<= _n;
  arg_1 = &arg_1_.in();

}

void _0RL_cd_6fe2f94a21a10053_00000000::marshalReturnedValues(cdrStream& _n)
{
  (const ::CORBA::Any&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_00000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new ::CORBA::Any;
  (::CORBA::Any&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_00000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_00000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_10000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_00000000* tcd = (_0RL_cd_6fe2f94a21a10053_00000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_inout(tcd->arg_0, *tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_inout(tcd->arg_0, *tcd->arg_1);
  else {
    try {
      tcd->result = impl->command_inout(tcd->arg_0, *tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

::CORBA::Any* Tango::_objref_Device::command_inout(const char* command, const ::CORBA::Any& argin)
{
  _0RL_cd_6fe2f94a21a10053_00000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_10000000, "command_inout", 14);
  _call_desc.arg_0 = command;
  _call_desc.arg_1 = &(::CORBA::Any&) argin;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeConfigList_i_cTango_mDevVarStringArray_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_20000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_20000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevVarStringArray_var arg_0_;
  const Tango::DevVarStringArray* arg_0;
  Tango::AttributeConfigList_var result;
};

void _0RL_cd_6fe2f94a21a10053_20000000::marshalArguments(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_20000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

void _0RL_cd_6fe2f94a21a10053_20000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeConfigList&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_20000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeConfigList;
  (Tango::AttributeConfigList&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_20000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_20000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_30000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_20000000* tcd = (_0RL_cd_6fe2f94a21a10053_20000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->get_attribute_config(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    tcd->result = impl->get_attribute_config(*tcd->arg_0);
  else {
    try {
      tcd->result = impl->get_attribute_config(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeConfigList* Tango::_objref_Device::get_attribute_config(const ::Tango::DevVarStringArray& names)
{
  _0RL_cd_6fe2f94a21a10053_20000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_30000000, "get_attribute_config", 21);
  _call_desc.arg_0 = &(::Tango::DevVarStringArray&) names;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  void_i_cTango_mAttributeConfigList_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_40000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_40000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

    
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::AttributeConfigList_var arg_0_;
  const Tango::AttributeConfigList* arg_0;
};

void _0RL_cd_6fe2f94a21a10053_40000000::marshalArguments(cdrStream& _n)
{
  (const Tango::AttributeConfigList&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_40000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::AttributeConfigList;
  (Tango::AttributeConfigList&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

const char* const _0RL_cd_6fe2f94a21a10053_40000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_40000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_50000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_40000000* tcd = (_0RL_cd_6fe2f94a21a10053_40000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  impl->set_attribute_config(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    impl->set_attribute_config(*tcd->arg_0);
  else {
    try {
      impl->set_attribute_config(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

void Tango::_objref_Device::set_attribute_config(const ::Tango::AttributeConfigList& new_conf)
{
  _0RL_cd_6fe2f94a21a10053_40000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_50000000, "set_attribute_config", 21);
  _call_desc.arg_0 = &(::Tango::AttributeConfigList&) new_conf;

  _invoke(_call_desc);



}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeValueList_i_cTango_mDevVarStringArray_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_60000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_60000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevVarStringArray_var arg_0_;
  const Tango::DevVarStringArray* arg_0;
  Tango::AttributeValueList_var result;
};

void _0RL_cd_6fe2f94a21a10053_60000000::marshalArguments(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_60000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

void _0RL_cd_6fe2f94a21a10053_60000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeValueList&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_60000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeValueList;
  (Tango::AttributeValueList&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_60000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_60000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_70000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_60000000* tcd = (_0RL_cd_6fe2f94a21a10053_60000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->read_attributes(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    tcd->result = impl->read_attributes(*tcd->arg_0);
  else {
    try {
      tcd->result = impl->read_attributes(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeValueList* Tango::_objref_Device::read_attributes(const ::Tango::DevVarStringArray& names)
{
  _0RL_cd_6fe2f94a21a10053_60000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_70000000, "read_attributes", 16);
  _call_desc.arg_0 = &(::Tango::DevVarStringArray&) names;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  void_i_cTango_mAttributeValueList_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_80000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_80000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

    
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::AttributeValueList_var arg_0_;
  const Tango::AttributeValueList* arg_0;
};

void _0RL_cd_6fe2f94a21a10053_80000000::marshalArguments(cdrStream& _n)
{
  (const Tango::AttributeValueList&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_80000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::AttributeValueList;
  (Tango::AttributeValueList&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

const char* const _0RL_cd_6fe2f94a21a10053_80000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_80000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_90000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_80000000* tcd = (_0RL_cd_6fe2f94a21a10053_80000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  impl->write_attributes(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    impl->write_attributes(*tcd->arg_0);
  else {
    try {
      impl->write_attributes(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

void Tango::_objref_Device::write_attributes(const ::Tango::AttributeValueList& values)
{
  _0RL_cd_6fe2f94a21a10053_80000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_90000000, "write_attributes", 17);
  _call_desc.arg_0 = &(::Tango::AttributeValueList&) values;

  _invoke(_call_desc);



}
// Proxy call descriptor class. Mangled signature:
//  void_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_a0000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_a0000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  
    
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  
};

const char* const _0RL_cd_6fe2f94a21a10053_a0000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_a0000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_b0000000(omniCallDescriptor* cd, omniServant* svnt)
{
  
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  impl->ping();
#else
  if (!cd->is_upcall())
    impl->ping();
  else {
    try {
      impl->ping();
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

void Tango::_objref_Device::ping()
{
  _0RL_cd_6fe2f94a21a10053_a0000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_b0000000, "ping", 5);


  _invoke(_call_desc);



}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevVarStringArray_i_clong_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_c0000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_c0000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::Long arg_0;
  Tango::DevVarStringArray_var result;
};

void _0RL_cd_6fe2f94a21a10053_c0000000::marshalArguments(cdrStream& _n)
{
  arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_c0000000::unmarshalArguments(cdrStream& _n)
{
  (::CORBA::Long&)arg_0 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_c0000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_c0000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_c0000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_c0000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_d0000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_c0000000* tcd = (_0RL_cd_6fe2f94a21a10053_c0000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->black_box(tcd->arg_0);
#else
  if (!cd->is_upcall())
    tcd->result = impl->black_box(tcd->arg_0);
  else {
    try {
      tcd->result = impl->black_box(tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevVarStringArray* Tango::_objref_Device::black_box(::CORBA::Long n)
{
  _0RL_cd_6fe2f94a21a10053_c0000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_d0000000, "black_box", 10);
  _call_desc.arg_0 = n;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevInfo_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_e0000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_e0000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  
  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevInfo_var result;
};

void _0RL_cd_6fe2f94a21a10053_e0000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevInfo&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_e0000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevInfo;
  (Tango::DevInfo&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_e0000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_e0000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_f0000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_e0000000* tcd = (_0RL_cd_6fe2f94a21a10053_e0000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->info();
#else
  if (!cd->is_upcall())
    tcd->result = impl->info();
  else {
    try {
      tcd->result = impl->info();
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevInfo* Tango::_objref_Device::info()
{
  _0RL_cd_6fe2f94a21a10053_e0000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_f0000000, "info", 5);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevCmdInfoList_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_01000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_01000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  
  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevCmdInfoList_var result;
};

void _0RL_cd_6fe2f94a21a10053_01000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevCmdInfoList&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_01000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevCmdInfoList;
  (Tango::DevCmdInfoList&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_01000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_01000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_11000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_01000000* tcd = (_0RL_cd_6fe2f94a21a10053_01000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_list_query();
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_list_query();
  else {
    try {
      tcd->result = impl->command_list_query();
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevCmdInfoList* Tango::_objref_Device::command_list_query()
{
  _0RL_cd_6fe2f94a21a10053_01000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_11000000, "command_list_query", 19);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevCmdInfo_i_cstring_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_21000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_21000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  Tango::DevCmdInfo_var result;
};

void _0RL_cd_6fe2f94a21a10053_21000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);

}

void _0RL_cd_6fe2f94a21a10053_21000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();

}

void _0RL_cd_6fe2f94a21a10053_21000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevCmdInfo&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_21000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevCmdInfo;
  (Tango::DevCmdInfo&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_21000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_21000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_31000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_21000000* tcd = (_0RL_cd_6fe2f94a21a10053_21000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_query(tcd->arg_0);
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_query(tcd->arg_0);
  else {
    try {
      tcd->result = impl->command_query(tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevCmdInfo* Tango::_objref_Device::command_query(const char* command)
{
  _0RL_cd_6fe2f94a21a10053_21000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_31000000, "command_query", 14);
  _call_desc.arg_0 = command;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cstring
class _0RL_cd_6fe2f94a21a10053_41000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_41000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 0, upcall)
  {
    
  }
  
  
  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  
  static const char* const _user_exns[];

  ::CORBA::String_var result;
};

void _0RL_cd_6fe2f94a21a10053_41000000::marshalReturnedValues(cdrStream& _n)
{
  _n.marshalString(result,0);

}

void _0RL_cd_6fe2f94a21a10053_41000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = _n.unmarshalString(0);

}

const char* const _0RL_cd_6fe2f94a21a10053_41000000::_user_exns[] = {
  0
};

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_51000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_41000000* tcd = (_0RL_cd_6fe2f94a21a10053_41000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
  tcd->result = impl->name();


}

char* Tango::_objref_Device::name()
{
  _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_51000000, "_get_name", 10);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_61000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_41000000* tcd = (_0RL_cd_6fe2f94a21a10053_41000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
  tcd->result = impl->description();


}

char* Tango::_objref_Device::description()
{
  _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_61000000, "_get_description", 17);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevState
class _0RL_cd_6fe2f94a21a10053_71000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_71000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 0, upcall)
  {
    
  }
  
  
  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  
  static const char* const _user_exns[];

  Tango::DevState result;
};

void _0RL_cd_6fe2f94a21a10053_71000000::marshalReturnedValues(cdrStream& _n)
{
  result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_71000000::unmarshalReturnedValues(cdrStream& _n)
{
  (Tango::DevState&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_71000000::_user_exns[] = {
  0
};

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_81000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_71000000* tcd = (_0RL_cd_6fe2f94a21a10053_71000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
  tcd->result = impl->state();


}

Tango::DevState Tango::_objref_Device::state()
{
  _0RL_cd_6fe2f94a21a10053_71000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_81000000, "_get_state", 11);


  _invoke(_call_desc);
  return _call_desc.result;


}
// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_91000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_41000000* tcd = (_0RL_cd_6fe2f94a21a10053_41000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
  tcd->result = impl->status();


}

char* Tango::_objref_Device::status()
{
  _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_91000000, "_get_status", 12);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_a1000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_41000000* tcd = (_0RL_cd_6fe2f94a21a10053_41000000*)cd;
  Tango::_impl_Device* impl = (Tango::_impl_Device*) svnt->_ptrToInterface(Tango::Device::_PD_repoId);
  tcd->result = impl->adm_name();


}

char* Tango::_objref_Device::adm_name()
{
  _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_a1000000, "_get_adm_name", 14);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
Tango::_pof_Device::~_pof_Device() {}


omniObjRef*
Tango::_pof_Device::newObjRef(omniIOR* ior, omniIdentity* id)
{
  return new ::Tango::_objref_Device(ior, id);
}


::CORBA::Boolean
Tango::_pof_Device::is_a(const char* id) const
{
  if( omni::ptrStrMatch(id, ::Tango::Device::_PD_repoId) )
    return 1;
  
  return 0;
}

const Tango::_pof_Device _the_pof_Tango_mDevice;

Tango::_impl_Device::~_impl_Device() {}


::CORBA::Boolean
Tango::_impl_Device::_dispatch(omniCallHandle& _handle)
{
  const char* op = _handle.operation_name();

  if( omni::strMatch(op, "command_inout") ) {

    _0RL_cd_6fe2f94a21a10053_00000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_10000000, "command_inout", 14, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "get_attribute_config") ) {

    _0RL_cd_6fe2f94a21a10053_20000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_30000000, "get_attribute_config", 21, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "set_attribute_config") ) {

    _0RL_cd_6fe2f94a21a10053_40000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_50000000, "set_attribute_config", 21, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "read_attributes") ) {

    _0RL_cd_6fe2f94a21a10053_60000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_70000000, "read_attributes", 16, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "write_attributes") ) {

    _0RL_cd_6fe2f94a21a10053_80000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_90000000, "write_attributes", 17, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "ping") ) {

    _0RL_cd_6fe2f94a21a10053_a0000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_b0000000, "ping", 5, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "black_box") ) {

    _0RL_cd_6fe2f94a21a10053_c0000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_d0000000, "black_box", 10, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "info") ) {

    _0RL_cd_6fe2f94a21a10053_e0000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_f0000000, "info", 5, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "command_list_query") ) {

    _0RL_cd_6fe2f94a21a10053_01000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_11000000, "command_list_query", 19, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "command_query") ) {

    _0RL_cd_6fe2f94a21a10053_21000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_31000000, "command_query", 14, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "_get_name") ) {

    _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_51000000, "_get_name", 10, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "_get_description") ) {

    _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_61000000, "_get_description", 17, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "_get_state") ) {

    _0RL_cd_6fe2f94a21a10053_71000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_81000000, "_get_state", 11, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "_get_status") ) {

    _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_91000000, "_get_status", 12, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "_get_adm_name") ) {

    _0RL_cd_6fe2f94a21a10053_41000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_a1000000, "_get_adm_name", 14, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }


  return 0;
}

void*
Tango::_impl_Device::_ptrToInterface(const char* id)
{
  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::_impl_Device*) this;
  
  if( id == ::CORBA::Object::_PD_repoId )
    return (void*) 1;

  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::_impl_Device*) this;
  
  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (void*) 1;
  return 0;
}

const char*
Tango::_impl_Device::_mostDerivedRepoId()
{
  return ::Tango::Device::_PD_repoId;
}

Tango::Device_2_ptr Tango::Device_2_Helper::_nil() {
  return ::Tango::Device_2::_nil();
}

::CORBA::Boolean Tango::Device_2_Helper::is_nil(::Tango::Device_2_ptr p) {
  return ::CORBA::is_nil(p);

}

void Tango::Device_2_Helper::release(::Tango::Device_2_ptr p) {
  ::CORBA::release(p);
}

void Tango::Device_2_Helper::marshalObjRef(::Tango::Device_2_ptr obj, cdrStream& s) {
  ::Tango::Device_2::_marshalObjRef(obj, s);
}

Tango::Device_2_ptr Tango::Device_2_Helper::unmarshalObjRef(cdrStream& s) {
  return ::Tango::Device_2::_unmarshalObjRef(s);
}

void Tango::Device_2_Helper::duplicate(::Tango::Device_2_ptr obj) {
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
}

Tango::Device_2_ptr
Tango::Device_2::_duplicate(::Tango::Device_2_ptr obj)
{
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
  return obj;
}

Tango::Device_2_ptr
Tango::Device_2::_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_realNarrow(_PD_repoId);
  return e ? e : _nil();
}


Tango::Device_2_ptr
Tango::Device_2::_unchecked_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_uncheckedNarrow(_PD_repoId);
  return e ? e : _nil();
}

Tango::Device_2_ptr
Tango::Device_2::_nil()
{
#ifdef OMNI_UNLOADABLE_STUBS
  static _objref_Device_2 _the_nil_obj;
  return &_the_nil_obj;
#else
  static _objref_Device_2* _the_nil_ptr = 0;
  if( !_the_nil_ptr ) {
    omni::nilRefLock().lock();
    if( !_the_nil_ptr ) {
      _the_nil_ptr = new _objref_Device_2;
      registerNilCorbaObject(_the_nil_ptr);
    }
    omni::nilRefLock().unlock();
  }
  return _the_nil_ptr;
#endif
}

const char* Tango::Device_2::_PD_repoId = "IDL:Tango/Device_2:1.0";


Tango::_objref_Device_2::~_objref_Device_2() {
  
}


Tango::_objref_Device_2::_objref_Device_2(omniIOR* ior, omniIdentity* id) :
   omniObjRef(::Tango::Device_2::_PD_repoId, ior, id, 1),
   OMNIORB_BASE_CTOR(Tango::)_objref_Device(ior, id)
   
{
  _PR_setobj(this);
}

void*
Tango::_objref_Device_2::_ptrToObjRef(const char* id)
{
  if( id == ::Tango::Device_2::_PD_repoId )
    return (::Tango::Device_2_ptr) this;
  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::Device_ptr) this;


  if( id == ::CORBA::Object::_PD_repoId )
    return (::CORBA::Object_ptr) this;

  if( omni::strMatch(id, ::Tango::Device_2::_PD_repoId) )
    return (::Tango::Device_2_ptr) this;
  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::Device_ptr) this;


  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (::CORBA::Object_ptr) this;

  return 0;
}

// Proxy call descriptor class. Mangled signature:
//  _cany_i_cstring_i_cany_i_cTango_mDevSource_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_b1000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_b1000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Any_var arg_1_;
  const ::CORBA::Any* arg_1;
  Tango::DevSource arg_2;
  ::CORBA::Any_var result;
};

void _0RL_cd_6fe2f94a21a10053_b1000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  (const ::CORBA::Any&) *arg_1 >>= _n;
  arg_2 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_b1000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  arg_1_ = new ::CORBA::Any;
  (::CORBA::Any&)arg_1_ <<= _n;
  arg_1 = &arg_1_.in();
  (Tango::DevSource&)arg_2 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_b1000000::marshalReturnedValues(cdrStream& _n)
{
  (const ::CORBA::Any&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_b1000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new ::CORBA::Any;
  (::CORBA::Any&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_b1000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_b1000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_c1000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_b1000000* tcd = (_0RL_cd_6fe2f94a21a10053_b1000000*)cd;
  Tango::_impl_Device_2* impl = (Tango::_impl_Device_2*) svnt->_ptrToInterface(Tango::Device_2::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_inout_2(tcd->arg_0, *tcd->arg_1, tcd->arg_2);
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_inout_2(tcd->arg_0, *tcd->arg_1, tcd->arg_2);
  else {
    try {
      tcd->result = impl->command_inout_2(tcd->arg_0, *tcd->arg_1, tcd->arg_2);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

::CORBA::Any* Tango::_objref_Device_2::command_inout_2(const char* command, const ::CORBA::Any& argin, ::Tango::DevSource source)
{
  _0RL_cd_6fe2f94a21a10053_b1000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_c1000000, "command_inout_2", 16);
  _call_desc.arg_0 = command;
  _call_desc.arg_1 = &(::CORBA::Any&) argin;
  _call_desc.arg_2 = source;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeValueList_i_cTango_mDevVarStringArray_i_cTango_mDevSource_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_d1000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_d1000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevVarStringArray_var arg_0_;
  const Tango::DevVarStringArray* arg_0;
  Tango::DevSource arg_1;
  Tango::AttributeValueList_var result;
};

void _0RL_cd_6fe2f94a21a10053_d1000000::marshalArguments(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) *arg_0 >>= _n;
  arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_d1000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();
  (Tango::DevSource&)arg_1 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_d1000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeValueList&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_d1000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeValueList;
  (Tango::AttributeValueList&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_d1000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_d1000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_e1000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_d1000000* tcd = (_0RL_cd_6fe2f94a21a10053_d1000000*)cd;
  Tango::_impl_Device_2* impl = (Tango::_impl_Device_2*) svnt->_ptrToInterface(Tango::Device_2::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->read_attributes_2(*tcd->arg_0, tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->read_attributes_2(*tcd->arg_0, tcd->arg_1);
  else {
    try {
      tcd->result = impl->read_attributes_2(*tcd->arg_0, tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeValueList* Tango::_objref_Device_2::read_attributes_2(const ::Tango::DevVarStringArray& names, ::Tango::DevSource source)
{
  _0RL_cd_6fe2f94a21a10053_d1000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_e1000000, "read_attributes_2", 18);
  _call_desc.arg_0 = &(::Tango::DevVarStringArray&) names;
  _call_desc.arg_1 = source;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeConfigList__2_i_cTango_mDevVarStringArray_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_f1000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_f1000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevVarStringArray_var arg_0_;
  const Tango::DevVarStringArray* arg_0;
  Tango::AttributeConfigList_2_var result;
};

void _0RL_cd_6fe2f94a21a10053_f1000000::marshalArguments(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_f1000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

void _0RL_cd_6fe2f94a21a10053_f1000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeConfigList_2&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_f1000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeConfigList_2;
  (Tango::AttributeConfigList_2&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_f1000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_f1000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_02000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_f1000000* tcd = (_0RL_cd_6fe2f94a21a10053_f1000000*)cd;
  Tango::_impl_Device_2* impl = (Tango::_impl_Device_2*) svnt->_ptrToInterface(Tango::Device_2::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->get_attribute_config_2(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    tcd->result = impl->get_attribute_config_2(*tcd->arg_0);
  else {
    try {
      tcd->result = impl->get_attribute_config_2(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeConfigList_2* Tango::_objref_Device_2::get_attribute_config_2(const ::Tango::DevVarStringArray& names)
{
  _0RL_cd_6fe2f94a21a10053_f1000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_02000000, "get_attribute_config_2", 23);
  _call_desc.arg_0 = &(::Tango::DevVarStringArray&) names;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevCmdInfoList__2_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_12000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_12000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  
  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevCmdInfoList_2_var result;
};

void _0RL_cd_6fe2f94a21a10053_12000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevCmdInfoList_2&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_12000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevCmdInfoList_2;
  (Tango::DevCmdInfoList_2&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_12000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_12000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_22000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_12000000* tcd = (_0RL_cd_6fe2f94a21a10053_12000000*)cd;
  Tango::_impl_Device_2* impl = (Tango::_impl_Device_2*) svnt->_ptrToInterface(Tango::Device_2::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_list_query_2();
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_list_query_2();
  else {
    try {
      tcd->result = impl->command_list_query_2();
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevCmdInfoList_2* Tango::_objref_Device_2::command_list_query_2()
{
  _0RL_cd_6fe2f94a21a10053_12000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_22000000, "command_list_query_2", 21);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevCmdInfo__2_i_cstring_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_32000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_32000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  Tango::DevCmdInfo_2_var result;
};

void _0RL_cd_6fe2f94a21a10053_32000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);

}

void _0RL_cd_6fe2f94a21a10053_32000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();

}

void _0RL_cd_6fe2f94a21a10053_32000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevCmdInfo_2&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_32000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevCmdInfo_2;
  (Tango::DevCmdInfo_2&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_32000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_32000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_42000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_32000000* tcd = (_0RL_cd_6fe2f94a21a10053_32000000*)cd;
  Tango::_impl_Device_2* impl = (Tango::_impl_Device_2*) svnt->_ptrToInterface(Tango::Device_2::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_query_2(tcd->arg_0);
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_query_2(tcd->arg_0);
  else {
    try {
      tcd->result = impl->command_query_2(tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevCmdInfo_2* Tango::_objref_Device_2::command_query_2(const char* command)
{
  _0RL_cd_6fe2f94a21a10053_32000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_42000000, "command_query_2", 16);
  _call_desc.arg_0 = command;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevCmdHistoryList_i_cstring_i_clong_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_52000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_52000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Long arg_1;
  Tango::DevCmdHistoryList_var result;
};

void _0RL_cd_6fe2f94a21a10053_52000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_52000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  (::CORBA::Long&)arg_1 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_52000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevCmdHistoryList&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_52000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevCmdHistoryList;
  (Tango::DevCmdHistoryList&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_52000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_52000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_62000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_52000000* tcd = (_0RL_cd_6fe2f94a21a10053_52000000*)cd;
  Tango::_impl_Device_2* impl = (Tango::_impl_Device_2*) svnt->_ptrToInterface(Tango::Device_2::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_inout_history_2(tcd->arg_0, tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_inout_history_2(tcd->arg_0, tcd->arg_1);
  else {
    try {
      tcd->result = impl->command_inout_history_2(tcd->arg_0, tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevCmdHistoryList* Tango::_objref_Device_2::command_inout_history_2(const char* command, ::CORBA::Long n)
{
  _0RL_cd_6fe2f94a21a10053_52000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_62000000, "command_inout_history_2", 24);
  _call_desc.arg_0 = command;
  _call_desc.arg_1 = n;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevAttrHistoryList_i_cstring_i_clong_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_72000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_72000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Long arg_1;
  Tango::DevAttrHistoryList_var result;
};

void _0RL_cd_6fe2f94a21a10053_72000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_72000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  (::CORBA::Long&)arg_1 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_72000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevAttrHistoryList&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_72000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevAttrHistoryList;
  (Tango::DevAttrHistoryList&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_72000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_72000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_82000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_72000000* tcd = (_0RL_cd_6fe2f94a21a10053_72000000*)cd;
  Tango::_impl_Device_2* impl = (Tango::_impl_Device_2*) svnt->_ptrToInterface(Tango::Device_2::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->read_attribute_history_2(tcd->arg_0, tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->read_attribute_history_2(tcd->arg_0, tcd->arg_1);
  else {
    try {
      tcd->result = impl->read_attribute_history_2(tcd->arg_0, tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevAttrHistoryList* Tango::_objref_Device_2::read_attribute_history_2(const char* name, ::CORBA::Long n)
{
  _0RL_cd_6fe2f94a21a10053_72000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_82000000, "read_attribute_history_2", 25);
  _call_desc.arg_0 = name;
  _call_desc.arg_1 = n;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
Tango::_pof_Device_2::~_pof_Device_2() {}


omniObjRef*
Tango::_pof_Device_2::newObjRef(omniIOR* ior, omniIdentity* id)
{
  return new ::Tango::_objref_Device_2(ior, id);
}


::CORBA::Boolean
Tango::_pof_Device_2::is_a(const char* id) const
{
  if( omni::ptrStrMatch(id, ::Tango::Device_2::_PD_repoId) )
    return 1;
  if( omni::ptrStrMatch(id, Tango::Device::_PD_repoId) )
    return 1;


  return 0;
}

const Tango::_pof_Device_2 _the_pof_Tango_mDevice__2;

Tango::_impl_Device_2::~_impl_Device_2() {}


::CORBA::Boolean
Tango::_impl_Device_2::_dispatch(omniCallHandle& _handle)
{
  const char* op = _handle.operation_name();

  if( omni::strMatch(op, "command_inout_2") ) {

    _0RL_cd_6fe2f94a21a10053_b1000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_c1000000, "command_inout_2", 16, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "read_attributes_2") ) {

    _0RL_cd_6fe2f94a21a10053_d1000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_e1000000, "read_attributes_2", 18, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "get_attribute_config_2") ) {

    _0RL_cd_6fe2f94a21a10053_f1000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_02000000, "get_attribute_config_2", 23, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "command_list_query_2") ) {

    _0RL_cd_6fe2f94a21a10053_12000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_22000000, "command_list_query_2", 21, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "command_query_2") ) {

    _0RL_cd_6fe2f94a21a10053_32000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_42000000, "command_query_2", 16, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "command_inout_history_2") ) {

    _0RL_cd_6fe2f94a21a10053_52000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_62000000, "command_inout_history_2", 24, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "read_attribute_history_2") ) {

    _0RL_cd_6fe2f94a21a10053_72000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_82000000, "read_attribute_history_2", 25, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  
#ifndef _MSC_VER
  if( _impl_Device::_dispatch(_handle) ) {
    return 1;
  }
#else
  // Work-around for incorrect MSVC code generation.
  if( ((_impl_Device*)this)->
      _impl_Device::_dispatch(_handle) ) {
    return 1;
  }
#endif


  return 0;
}

void*
Tango::_impl_Device_2::_ptrToInterface(const char* id)
{
  if( id == ::Tango::Device_2::_PD_repoId )
    return (::Tango::_impl_Device_2*) this;
  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::_impl_Device*) this;


  if( id == ::CORBA::Object::_PD_repoId )
    return (void*) 1;

  if( omni::strMatch(id, ::Tango::Device_2::_PD_repoId) )
    return (::Tango::_impl_Device_2*) this;
  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::_impl_Device*) this;


  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (void*) 1;
  return 0;
}

const char*
Tango::_impl_Device_2::_mostDerivedRepoId()
{
  return ::Tango::Device_2::_PD_repoId;
}

Tango::Device_3_ptr Tango::Device_3_Helper::_nil() {
  return ::Tango::Device_3::_nil();
}

::CORBA::Boolean Tango::Device_3_Helper::is_nil(::Tango::Device_3_ptr p) {
  return ::CORBA::is_nil(p);

}

void Tango::Device_3_Helper::release(::Tango::Device_3_ptr p) {
  ::CORBA::release(p);
}

void Tango::Device_3_Helper::marshalObjRef(::Tango::Device_3_ptr obj, cdrStream& s) {
  ::Tango::Device_3::_marshalObjRef(obj, s);
}

Tango::Device_3_ptr Tango::Device_3_Helper::unmarshalObjRef(cdrStream& s) {
  return ::Tango::Device_3::_unmarshalObjRef(s);
}

void Tango::Device_3_Helper::duplicate(::Tango::Device_3_ptr obj) {
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
}

Tango::Device_3_ptr
Tango::Device_3::_duplicate(::Tango::Device_3_ptr obj)
{
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
  return obj;
}

Tango::Device_3_ptr
Tango::Device_3::_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_realNarrow(_PD_repoId);
  return e ? e : _nil();
}


Tango::Device_3_ptr
Tango::Device_3::_unchecked_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_uncheckedNarrow(_PD_repoId);
  return e ? e : _nil();
}

Tango::Device_3_ptr
Tango::Device_3::_nil()
{
#ifdef OMNI_UNLOADABLE_STUBS
  static _objref_Device_3 _the_nil_obj;
  return &_the_nil_obj;
#else
  static _objref_Device_3* _the_nil_ptr = 0;
  if( !_the_nil_ptr ) {
    omni::nilRefLock().lock();
    if( !_the_nil_ptr ) {
      _the_nil_ptr = new _objref_Device_3;
      registerNilCorbaObject(_the_nil_ptr);
    }
    omni::nilRefLock().unlock();
  }
  return _the_nil_ptr;
#endif
}

const char* Tango::Device_3::_PD_repoId = "IDL:Tango/Device_3:1.0";


Tango::_objref_Device_3::~_objref_Device_3() {
  
}


Tango::_objref_Device_3::_objref_Device_3(omniIOR* ior, omniIdentity* id) :
   omniObjRef(::Tango::Device_3::_PD_repoId, ior, id, 1),
   OMNIORB_BASE_CTOR(Tango::)_objref_Device_2(ior, id)
   
{
  _PR_setobj(this);
}

void*
Tango::_objref_Device_3::_ptrToObjRef(const char* id)
{
  if( id == ::Tango::Device_3::_PD_repoId )
    return (::Tango::Device_3_ptr) this;
  if( id == ::Tango::Device_2::_PD_repoId )
    return (::Tango::Device_2_ptr) this;

  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::Device_ptr) this;


  if( id == ::CORBA::Object::_PD_repoId )
    return (::CORBA::Object_ptr) this;

  if( omni::strMatch(id, ::Tango::Device_3::_PD_repoId) )
    return (::Tango::Device_3_ptr) this;
  if( omni::strMatch(id, ::Tango::Device_2::_PD_repoId) )
    return (::Tango::Device_2_ptr) this;

  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::Device_ptr) this;


  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (::CORBA::Object_ptr) this;

  return 0;
}

// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeValueList__3_i_cTango_mDevVarStringArray_i_cTango_mDevSource_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_92000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_92000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevVarStringArray_var arg_0_;
  const Tango::DevVarStringArray* arg_0;
  Tango::DevSource arg_1;
  Tango::AttributeValueList_3_var result;
};

void _0RL_cd_6fe2f94a21a10053_92000000::marshalArguments(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) *arg_0 >>= _n;
  arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_92000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();
  (Tango::DevSource&)arg_1 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_92000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeValueList_3&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_92000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeValueList_3;
  (Tango::AttributeValueList_3&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_92000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_92000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_a2000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_92000000* tcd = (_0RL_cd_6fe2f94a21a10053_92000000*)cd;
  Tango::_impl_Device_3* impl = (Tango::_impl_Device_3*) svnt->_ptrToInterface(Tango::Device_3::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->read_attributes_3(*tcd->arg_0, tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->read_attributes_3(*tcd->arg_0, tcd->arg_1);
  else {
    try {
      tcd->result = impl->read_attributes_3(*tcd->arg_0, tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeValueList_3* Tango::_objref_Device_3::read_attributes_3(const ::Tango::DevVarStringArray& names, ::Tango::DevSource source)
{
  _0RL_cd_6fe2f94a21a10053_92000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_a2000000, "read_attributes_3", 18);
  _call_desc.arg_0 = &(::Tango::DevVarStringArray&) names;
  _call_desc.arg_1 = source;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  void_i_cTango_mAttributeValueList_e_cTango_mDevFailed_e_cTango_mMultiDevFailed
class _0RL_cd_6fe2f94a21a10053_b2000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_b2000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 2, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

    
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::AttributeValueList_var arg_0_;
  const Tango::AttributeValueList* arg_0;
};

void _0RL_cd_6fe2f94a21a10053_b2000000::marshalArguments(cdrStream& _n)
{
  (const Tango::AttributeValueList&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_b2000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::AttributeValueList;
  (Tango::AttributeValueList&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

const char* const _0RL_cd_6fe2f94a21a10053_b2000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId,
  Tango::MultiDevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_b2000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }

  if ( omni::strMatch(repoId, Tango::MultiDevFailed::_PD_repoId) ) {
    Tango::MultiDevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_c2000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_b2000000* tcd = (_0RL_cd_6fe2f94a21a10053_b2000000*)cd;
  Tango::_impl_Device_3* impl = (Tango::_impl_Device_3*) svnt->_ptrToInterface(Tango::Device_3::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  impl->write_attributes_3(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    impl->write_attributes_3(*tcd->arg_0);
  else {
    try {
      impl->write_attributes_3(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }

    catch(Tango::MultiDevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

void Tango::_objref_Device_3::write_attributes_3(const ::Tango::AttributeValueList& values)
{
  _0RL_cd_6fe2f94a21a10053_b2000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_c2000000, "write_attributes_3", 19);
  _call_desc.arg_0 = &(::Tango::AttributeValueList&) values;

  _invoke(_call_desc);



}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevAttrHistoryList__3_i_cstring_i_clong_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_d2000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_d2000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Long arg_1;
  Tango::DevAttrHistoryList_3_var result;
};

void _0RL_cd_6fe2f94a21a10053_d2000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_d2000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  (::CORBA::Long&)arg_1 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_d2000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevAttrHistoryList_3&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_d2000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevAttrHistoryList_3;
  (Tango::DevAttrHistoryList_3&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_d2000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_d2000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_e2000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_d2000000* tcd = (_0RL_cd_6fe2f94a21a10053_d2000000*)cd;
  Tango::_impl_Device_3* impl = (Tango::_impl_Device_3*) svnt->_ptrToInterface(Tango::Device_3::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->read_attribute_history_3(tcd->arg_0, tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->read_attribute_history_3(tcd->arg_0, tcd->arg_1);
  else {
    try {
      tcd->result = impl->read_attribute_history_3(tcd->arg_0, tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevAttrHistoryList_3* Tango::_objref_Device_3::read_attribute_history_3(const char* name, ::CORBA::Long n)
{
  _0RL_cd_6fe2f94a21a10053_d2000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_e2000000, "read_attribute_history_3", 25);
  _call_desc.arg_0 = name;
  _call_desc.arg_1 = n;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevInfo__3_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_f2000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_f2000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  
  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevInfo_3_var result;
};

void _0RL_cd_6fe2f94a21a10053_f2000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevInfo_3&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_f2000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevInfo_3;
  (Tango::DevInfo_3&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_f2000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_f2000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_03000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_f2000000* tcd = (_0RL_cd_6fe2f94a21a10053_f2000000*)cd;
  Tango::_impl_Device_3* impl = (Tango::_impl_Device_3*) svnt->_ptrToInterface(Tango::Device_3::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->info_3();
#else
  if (!cd->is_upcall())
    tcd->result = impl->info_3();
  else {
    try {
      tcd->result = impl->info_3();
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevInfo_3* Tango::_objref_Device_3::info_3()
{
  _0RL_cd_6fe2f94a21a10053_f2000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_03000000, "info_3", 7);


  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeConfigList__3_i_cTango_mDevVarStringArray_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_13000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_13000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevVarStringArray_var arg_0_;
  const Tango::DevVarStringArray* arg_0;
  Tango::AttributeConfigList_3_var result;
};

void _0RL_cd_6fe2f94a21a10053_13000000::marshalArguments(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_13000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

void _0RL_cd_6fe2f94a21a10053_13000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeConfigList_3&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_13000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeConfigList_3;
  (Tango::AttributeConfigList_3&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_13000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_13000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_23000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_13000000* tcd = (_0RL_cd_6fe2f94a21a10053_13000000*)cd;
  Tango::_impl_Device_3* impl = (Tango::_impl_Device_3*) svnt->_ptrToInterface(Tango::Device_3::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->get_attribute_config_3(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    tcd->result = impl->get_attribute_config_3(*tcd->arg_0);
  else {
    try {
      tcd->result = impl->get_attribute_config_3(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeConfigList_3* Tango::_objref_Device_3::get_attribute_config_3(const ::Tango::DevVarStringArray& names)
{
  _0RL_cd_6fe2f94a21a10053_13000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_23000000, "get_attribute_config_3", 23);
  _call_desc.arg_0 = &(::Tango::DevVarStringArray&) names;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  void_i_cTango_mAttributeConfigList__3_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_33000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_33000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

    
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::AttributeConfigList_3_var arg_0_;
  const Tango::AttributeConfigList_3* arg_0;
};

void _0RL_cd_6fe2f94a21a10053_33000000::marshalArguments(cdrStream& _n)
{
  (const Tango::AttributeConfigList_3&) *arg_0 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_33000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::AttributeConfigList_3;
  (Tango::AttributeConfigList_3&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();

}

const char* const _0RL_cd_6fe2f94a21a10053_33000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_33000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_43000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_33000000* tcd = (_0RL_cd_6fe2f94a21a10053_33000000*)cd;
  Tango::_impl_Device_3* impl = (Tango::_impl_Device_3*) svnt->_ptrToInterface(Tango::Device_3::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  impl->set_attribute_config_3(*tcd->arg_0);
#else
  if (!cd->is_upcall())
    impl->set_attribute_config_3(*tcd->arg_0);
  else {
    try {
      impl->set_attribute_config_3(*tcd->arg_0);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

void Tango::_objref_Device_3::set_attribute_config_3(const ::Tango::AttributeConfigList_3& new_conf)
{
  _0RL_cd_6fe2f94a21a10053_33000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_43000000, "set_attribute_config_3", 23);
  _call_desc.arg_0 = &(::Tango::AttributeConfigList_3&) new_conf;

  _invoke(_call_desc);



}
Tango::_pof_Device_3::~_pof_Device_3() {}


omniObjRef*
Tango::_pof_Device_3::newObjRef(omniIOR* ior, omniIdentity* id)
{
  return new ::Tango::_objref_Device_3(ior, id);
}


::CORBA::Boolean
Tango::_pof_Device_3::is_a(const char* id) const
{
  if( omni::ptrStrMatch(id, ::Tango::Device_3::_PD_repoId) )
    return 1;
  if( omni::ptrStrMatch(id, Tango::Device_2::_PD_repoId) )
    return 1;

  if( omni::ptrStrMatch(id, Tango::Device::_PD_repoId) )
    return 1;


  return 0;
}

const Tango::_pof_Device_3 _the_pof_Tango_mDevice__3;

Tango::_impl_Device_3::~_impl_Device_3() {}


::CORBA::Boolean
Tango::_impl_Device_3::_dispatch(omniCallHandle& _handle)
{
  const char* op = _handle.operation_name();

  if( omni::strMatch(op, "read_attributes_3") ) {

    _0RL_cd_6fe2f94a21a10053_92000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_a2000000, "read_attributes_3", 18, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "write_attributes_3") ) {

    _0RL_cd_6fe2f94a21a10053_b2000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_c2000000, "write_attributes_3", 19, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "read_attribute_history_3") ) {

    _0RL_cd_6fe2f94a21a10053_d2000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_e2000000, "read_attribute_history_3", 25, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "info_3") ) {

    _0RL_cd_6fe2f94a21a10053_f2000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_03000000, "info_3", 7, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "get_attribute_config_3") ) {

    _0RL_cd_6fe2f94a21a10053_13000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_23000000, "get_attribute_config_3", 23, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "set_attribute_config_3") ) {

    _0RL_cd_6fe2f94a21a10053_33000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_43000000, "set_attribute_config_3", 23, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  
#ifndef _MSC_VER
  if( _impl_Device_2::_dispatch(_handle) ) {
    return 1;
  }
#else
  // Work-around for incorrect MSVC code generation.
  if( ((_impl_Device_2*)this)->
      _impl_Device_2::_dispatch(_handle) ) {
    return 1;
  }
#endif


  return 0;
}

void*
Tango::_impl_Device_3::_ptrToInterface(const char* id)
{
  if( id == ::Tango::Device_3::_PD_repoId )
    return (::Tango::_impl_Device_3*) this;
  if( id == ::Tango::Device_2::_PD_repoId )
    return (::Tango::_impl_Device_2*) this;

  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::_impl_Device*) this;


  if( id == ::CORBA::Object::_PD_repoId )
    return (void*) 1;

  if( omni::strMatch(id, ::Tango::Device_3::_PD_repoId) )
    return (::Tango::_impl_Device_3*) this;
  if( omni::strMatch(id, ::Tango::Device_2::_PD_repoId) )
    return (::Tango::_impl_Device_2*) this;

  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::_impl_Device*) this;


  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (void*) 1;
  return 0;
}

const char*
Tango::_impl_Device_3::_mostDerivedRepoId()
{
  return ::Tango::Device_3::_PD_repoId;
}

Tango::Device_4_ptr Tango::Device_4_Helper::_nil() {
  return ::Tango::Device_4::_nil();
}

::CORBA::Boolean Tango::Device_4_Helper::is_nil(::Tango::Device_4_ptr p) {
  return ::CORBA::is_nil(p);

}

void Tango::Device_4_Helper::release(::Tango::Device_4_ptr p) {
  ::CORBA::release(p);
}

void Tango::Device_4_Helper::marshalObjRef(::Tango::Device_4_ptr obj, cdrStream& s) {
  ::Tango::Device_4::_marshalObjRef(obj, s);
}

Tango::Device_4_ptr Tango::Device_4_Helper::unmarshalObjRef(cdrStream& s) {
  return ::Tango::Device_4::_unmarshalObjRef(s);
}

void Tango::Device_4_Helper::duplicate(::Tango::Device_4_ptr obj) {
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
}

Tango::Device_4_ptr
Tango::Device_4::_duplicate(::Tango::Device_4_ptr obj)
{
  if( obj && !obj->_NP_is_nil() )  omni::duplicateObjRef(obj);
  return obj;
}

Tango::Device_4_ptr
Tango::Device_4::_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_realNarrow(_PD_repoId);
  return e ? e : _nil();
}


Tango::Device_4_ptr
Tango::Device_4::_unchecked_narrow(::CORBA::Object_ptr obj)
{
  if( !obj || obj->_NP_is_nil() || obj->_NP_is_pseudo() ) return _nil();
  _ptr_type e = (_ptr_type) obj->_PR_getobj()->_uncheckedNarrow(_PD_repoId);
  return e ? e : _nil();
}

Tango::Device_4_ptr
Tango::Device_4::_nil()
{
#ifdef OMNI_UNLOADABLE_STUBS
  static _objref_Device_4 _the_nil_obj;
  return &_the_nil_obj;
#else
  static _objref_Device_4* _the_nil_ptr = 0;
  if( !_the_nil_ptr ) {
    omni::nilRefLock().lock();
    if( !_the_nil_ptr ) {
      _the_nil_ptr = new _objref_Device_4;
      registerNilCorbaObject(_the_nil_ptr);
    }
    omni::nilRefLock().unlock();
  }
  return _the_nil_ptr;
#endif
}

const char* Tango::Device_4::_PD_repoId = "IDL:Tango/Device_4:1.0";


Tango::_objref_Device_4::~_objref_Device_4() {
  
}


Tango::_objref_Device_4::_objref_Device_4(omniIOR* ior, omniIdentity* id) :
   omniObjRef(::Tango::Device_4::_PD_repoId, ior, id, 1),
   OMNIORB_BASE_CTOR(Tango::)_objref_Device_3(ior, id)
   
{
  _PR_setobj(this);
}

void*
Tango::_objref_Device_4::_ptrToObjRef(const char* id)
{
  if( id == ::Tango::Device_4::_PD_repoId )
    return (::Tango::Device_4_ptr) this;
  if( id == ::Tango::Device_3::_PD_repoId )
    return (::Tango::Device_3_ptr) this;

  if( id == ::Tango::Device_2::_PD_repoId )
    return (::Tango::Device_2_ptr) this;

  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::Device_ptr) this;


  if( id == ::CORBA::Object::_PD_repoId )
    return (::CORBA::Object_ptr) this;

  if( omni::strMatch(id, ::Tango::Device_4::_PD_repoId) )
    return (::Tango::Device_4_ptr) this;
  if( omni::strMatch(id, ::Tango::Device_3::_PD_repoId) )
    return (::Tango::Device_3_ptr) this;

  if( omni::strMatch(id, ::Tango::Device_2::_PD_repoId) )
    return (::Tango::Device_2_ptr) this;

  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::Device_ptr) this;


  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (::CORBA::Object_ptr) this;

  return 0;
}

// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevAttrHistory__4_i_cstring_i_clong_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_53000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_53000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Long arg_1;
  Tango::DevAttrHistory_4_var result;
};

void _0RL_cd_6fe2f94a21a10053_53000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_53000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  (::CORBA::Long&)arg_1 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_53000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevAttrHistory_4&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_53000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevAttrHistory_4;
  (Tango::DevAttrHistory_4&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_53000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_53000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_63000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_53000000* tcd = (_0RL_cd_6fe2f94a21a10053_53000000*)cd;
  Tango::_impl_Device_4* impl = (Tango::_impl_Device_4*) svnt->_ptrToInterface(Tango::Device_4::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->read_attribute_history_4(tcd->arg_0, tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->read_attribute_history_4(tcd->arg_0, tcd->arg_1);
  else {
    try {
      tcd->result = impl->read_attribute_history_4(tcd->arg_0, tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevAttrHistory_4* Tango::_objref_Device_4::read_attribute_history_4(const char* name, ::CORBA::Long n)
{
  _0RL_cd_6fe2f94a21a10053_53000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_63000000, "read_attribute_history_4", 25);
  _call_desc.arg_0 = name;
  _call_desc.arg_1 = n;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mDevCmdHistory__4_i_cstring_i_clong_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_73000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_73000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Long arg_1;
  Tango::DevCmdHistory_4_var result;
};

void _0RL_cd_6fe2f94a21a10053_73000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_73000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  (::CORBA::Long&)arg_1 <<= _n;

}

void _0RL_cd_6fe2f94a21a10053_73000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::DevCmdHistory_4&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_73000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::DevCmdHistory_4;
  (Tango::DevCmdHistory_4&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_73000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_73000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_83000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_73000000* tcd = (_0RL_cd_6fe2f94a21a10053_73000000*)cd;
  Tango::_impl_Device_4* impl = (Tango::_impl_Device_4*) svnt->_ptrToInterface(Tango::Device_4::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_inout_history_4(tcd->arg_0, tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_inout_history_4(tcd->arg_0, tcd->arg_1);
  else {
    try {
      tcd->result = impl->command_inout_history_4(tcd->arg_0, tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::DevCmdHistory_4* Tango::_objref_Device_4::command_inout_history_4(const char* command, ::CORBA::Long n)
{
  _0RL_cd_6fe2f94a21a10053_73000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_83000000, "command_inout_history_4", 24);
  _call_desc.arg_0 = command;
  _call_desc.arg_1 = n;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cany_i_cstring_i_cany_i_cTango_mDevSource_i_cTango_mClntIdent_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_93000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_93000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  ::CORBA::String_var arg_0_;
  const char* arg_0;
  ::CORBA::Any_var arg_1_;
  const ::CORBA::Any* arg_1;
  Tango::DevSource arg_2;
  Tango::ClntIdent_var arg_3_;
  const Tango::ClntIdent* arg_3;
  ::CORBA::Any_var result;
};

void _0RL_cd_6fe2f94a21a10053_93000000::marshalArguments(cdrStream& _n)
{
  _n.marshalString(arg_0,0);
  (const ::CORBA::Any&) *arg_1 >>= _n;
  arg_2 >>= _n;
  (const Tango::ClntIdent&) *arg_3 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_93000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = _n.unmarshalString(0);
  arg_0 = arg_0_.in();
  arg_1_ = new ::CORBA::Any;
  (::CORBA::Any&)arg_1_ <<= _n;
  arg_1 = &arg_1_.in();
  (Tango::DevSource&)arg_2 <<= _n;
  arg_3_ = new Tango::ClntIdent;
  (Tango::ClntIdent&)arg_3_ <<= _n;
  arg_3 = &arg_3_.in();

}

void _0RL_cd_6fe2f94a21a10053_93000000::marshalReturnedValues(cdrStream& _n)
{
  (const ::CORBA::Any&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_93000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new ::CORBA::Any;
  (::CORBA::Any&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_93000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_93000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_a3000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_93000000* tcd = (_0RL_cd_6fe2f94a21a10053_93000000*)cd;
  Tango::_impl_Device_4* impl = (Tango::_impl_Device_4*) svnt->_ptrToInterface(Tango::Device_4::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->command_inout_4(tcd->arg_0, *tcd->arg_1, tcd->arg_2, *tcd->arg_3);
#else
  if (!cd->is_upcall())
    tcd->result = impl->command_inout_4(tcd->arg_0, *tcd->arg_1, tcd->arg_2, *tcd->arg_3);
  else {
    try {
      tcd->result = impl->command_inout_4(tcd->arg_0, *tcd->arg_1, tcd->arg_2, *tcd->arg_3);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

::CORBA::Any* Tango::_objref_Device_4::command_inout_4(const char* command, const ::CORBA::Any& argin, ::Tango::DevSource source, const ::Tango::ClntIdent& cl_ident)
{
  _0RL_cd_6fe2f94a21a10053_93000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_a3000000, "command_inout_4", 16);
  _call_desc.arg_0 = command;
  _call_desc.arg_1 = &(::CORBA::Any&) argin;
  _call_desc.arg_2 = source;
  _call_desc.arg_3 = &(::Tango::ClntIdent&) cl_ident;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeValueList__4_i_cTango_mDevVarStringArray_i_cTango_mDevSource_i_cTango_mClntIdent_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_b3000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_b3000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::DevVarStringArray_var arg_0_;
  const Tango::DevVarStringArray* arg_0;
  Tango::DevSource arg_1;
  Tango::ClntIdent_var arg_2_;
  const Tango::ClntIdent* arg_2;
  Tango::AttributeValueList_4_var result;
};

void _0RL_cd_6fe2f94a21a10053_b3000000::marshalArguments(cdrStream& _n)
{
  (const Tango::DevVarStringArray&) *arg_0 >>= _n;
  arg_1 >>= _n;
  (const Tango::ClntIdent&) *arg_2 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_b3000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::DevVarStringArray;
  (Tango::DevVarStringArray&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();
  (Tango::DevSource&)arg_1 <<= _n;
  arg_2_ = new Tango::ClntIdent;
  (Tango::ClntIdent&)arg_2_ <<= _n;
  arg_2 = &arg_2_.in();

}

void _0RL_cd_6fe2f94a21a10053_b3000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeValueList_4&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_b3000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeValueList_4;
  (Tango::AttributeValueList_4&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_b3000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_b3000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_c3000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_b3000000* tcd = (_0RL_cd_6fe2f94a21a10053_b3000000*)cd;
  Tango::_impl_Device_4* impl = (Tango::_impl_Device_4*) svnt->_ptrToInterface(Tango::Device_4::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->read_attributes_4(*tcd->arg_0, tcd->arg_1, *tcd->arg_2);
#else
  if (!cd->is_upcall())
    tcd->result = impl->read_attributes_4(*tcd->arg_0, tcd->arg_1, *tcd->arg_2);
  else {
    try {
      tcd->result = impl->read_attributes_4(*tcd->arg_0, tcd->arg_1, *tcd->arg_2);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeValueList_4* Tango::_objref_Device_4::read_attributes_4(const ::Tango::DevVarStringArray& names, ::Tango::DevSource source, const ::Tango::ClntIdent& cl_ident)
{
  _0RL_cd_6fe2f94a21a10053_b3000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_c3000000, "read_attributes_4", 18);
  _call_desc.arg_0 = &(::Tango::DevVarStringArray&) names;
  _call_desc.arg_1 = source;
  _call_desc.arg_2 = &(::Tango::ClntIdent&) cl_ident;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
// Proxy call descriptor class. Mangled signature:
//  void_i_cTango_mAttributeValueList__4_i_cTango_mClntIdent_e_cTango_mDevFailed_e_cTango_mMultiDevFailed
class _0RL_cd_6fe2f94a21a10053_d3000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_d3000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 2, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

    
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::AttributeValueList_4_var arg_0_;
  const Tango::AttributeValueList_4* arg_0;
  Tango::ClntIdent_var arg_1_;
  const Tango::ClntIdent* arg_1;
};

void _0RL_cd_6fe2f94a21a10053_d3000000::marshalArguments(cdrStream& _n)
{
  (const Tango::AttributeValueList_4&) *arg_0 >>= _n;
  (const Tango::ClntIdent&) *arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_d3000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::AttributeValueList_4;
  (Tango::AttributeValueList_4&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();
  arg_1_ = new Tango::ClntIdent;
  (Tango::ClntIdent&)arg_1_ <<= _n;
  arg_1 = &arg_1_.in();

}

const char* const _0RL_cd_6fe2f94a21a10053_d3000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId,
  Tango::MultiDevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_d3000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }

  if ( omni::strMatch(repoId, Tango::MultiDevFailed::_PD_repoId) ) {
    Tango::MultiDevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_e3000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_d3000000* tcd = (_0RL_cd_6fe2f94a21a10053_d3000000*)cd;
  Tango::_impl_Device_4* impl = (Tango::_impl_Device_4*) svnt->_ptrToInterface(Tango::Device_4::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  impl->write_attributes_4(*tcd->arg_0, *tcd->arg_1);
#else
  if (!cd->is_upcall())
    impl->write_attributes_4(*tcd->arg_0, *tcd->arg_1);
  else {
    try {
      impl->write_attributes_4(*tcd->arg_0, *tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }

    catch(Tango::MultiDevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

void Tango::_objref_Device_4::write_attributes_4(const ::Tango::AttributeValueList_4& values, const ::Tango::ClntIdent& cl_ident)
{
  _0RL_cd_6fe2f94a21a10053_d3000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_e3000000, "write_attributes_4", 19);
  _call_desc.arg_0 = &(::Tango::AttributeValueList_4&) values;
  _call_desc.arg_1 = &(::Tango::ClntIdent&) cl_ident;

  _invoke(_call_desc);



}
// Proxy call descriptor class. Mangled signature:
//  void_i_cTango_mAttributeConfigList__3_i_cTango_mClntIdent_e_cTango_mDevFailed
class _0RL_cd_6fe2f94a21a10053_f3000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_f3000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 1, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

    
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::AttributeConfigList_3_var arg_0_;
  const Tango::AttributeConfigList_3* arg_0;
  Tango::ClntIdent_var arg_1_;
  const Tango::ClntIdent* arg_1;
};

void _0RL_cd_6fe2f94a21a10053_f3000000::marshalArguments(cdrStream& _n)
{
  (const Tango::AttributeConfigList_3&) *arg_0 >>= _n;
  (const Tango::ClntIdent&) *arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_f3000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::AttributeConfigList_3;
  (Tango::AttributeConfigList_3&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();
  arg_1_ = new Tango::ClntIdent;
  (Tango::ClntIdent&)arg_1_ <<= _n;
  arg_1 = &arg_1_.in();

}

const char* const _0RL_cd_6fe2f94a21a10053_f3000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_f3000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_04000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_f3000000* tcd = (_0RL_cd_6fe2f94a21a10053_f3000000*)cd;
  Tango::_impl_Device_4* impl = (Tango::_impl_Device_4*) svnt->_ptrToInterface(Tango::Device_4::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  impl->set_attribute_config_4(*tcd->arg_0, *tcd->arg_1);
#else
  if (!cd->is_upcall())
    impl->set_attribute_config_4(*tcd->arg_0, *tcd->arg_1);
  else {
    try {
      impl->set_attribute_config_4(*tcd->arg_0, *tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

void Tango::_objref_Device_4::set_attribute_config_4(const ::Tango::AttributeConfigList_3& new_conf, const ::Tango::ClntIdent& cl_ident)
{
  _0RL_cd_6fe2f94a21a10053_f3000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_04000000, "set_attribute_config_4", 23);
  _call_desc.arg_0 = &(::Tango::AttributeConfigList_3&) new_conf;
  _call_desc.arg_1 = &(::Tango::ClntIdent&) cl_ident;

  _invoke(_call_desc);



}
// Proxy call descriptor class. Mangled signature:
//  _cTango_mAttributeValueList__4_i_cTango_mAttributeValueList__4_i_cTango_mClntIdent_e_cTango_mDevFailed_e_cTango_mMultiDevFailed
class _0RL_cd_6fe2f94a21a10053_14000000
  : public omniCallDescriptor
{
public:
  inline _0RL_cd_6fe2f94a21a10053_14000000(LocalCallFn lcfn,const char* op_,size_t oplen,_CORBA_Boolean upcall=0):
     omniCallDescriptor(lcfn, op_, oplen, 0, _user_exns, 2, upcall)
  {
    
  }
  
  void marshalArguments(cdrStream&);
  void unmarshalArguments(cdrStream&);

  void unmarshalReturnedValues(cdrStream&);
  void marshalReturnedValues(cdrStream&);
  
  void userException(cdrStream&,_OMNI_NS(IOP_C)*,const char*);
  static const char* const _user_exns[];

  Tango::AttributeValueList_4_var arg_0_;
  const Tango::AttributeValueList_4* arg_0;
  Tango::ClntIdent_var arg_1_;
  const Tango::ClntIdent* arg_1;
  Tango::AttributeValueList_4_var result;
};

void _0RL_cd_6fe2f94a21a10053_14000000::marshalArguments(cdrStream& _n)
{
  (const Tango::AttributeValueList_4&) *arg_0 >>= _n;
  (const Tango::ClntIdent&) *arg_1 >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_14000000::unmarshalArguments(cdrStream& _n)
{
  arg_0_ = new Tango::AttributeValueList_4;
  (Tango::AttributeValueList_4&)arg_0_ <<= _n;
  arg_0 = &arg_0_.in();
  arg_1_ = new Tango::ClntIdent;
  (Tango::ClntIdent&)arg_1_ <<= _n;
  arg_1 = &arg_1_.in();

}

void _0RL_cd_6fe2f94a21a10053_14000000::marshalReturnedValues(cdrStream& _n)
{
  (const Tango::AttributeValueList_4&) result >>= _n;

}

void _0RL_cd_6fe2f94a21a10053_14000000::unmarshalReturnedValues(cdrStream& _n)
{
  result = new Tango::AttributeValueList_4;
  (Tango::AttributeValueList_4&)result <<= _n;

}

const char* const _0RL_cd_6fe2f94a21a10053_14000000::_user_exns[] = {
  Tango::DevFailed::_PD_repoId,
  Tango::MultiDevFailed::_PD_repoId
};

void _0RL_cd_6fe2f94a21a10053_14000000::userException(cdrStream& s, _OMNI_NS(IOP_C)* iop_client, const char* repoId)
{
  if ( omni::strMatch(repoId, Tango::DevFailed::_PD_repoId) ) {
    Tango::DevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }

  if ( omni::strMatch(repoId, Tango::MultiDevFailed::_PD_repoId) ) {
    Tango::MultiDevFailed _ex;
    _ex <<= s;
    if (iop_client) iop_client->RequestCompleted();
    throw _ex;
  }


  else {
    if (iop_client) iop_client->RequestCompleted(1);
    OMNIORB_THROW(UNKNOWN,UNKNOWN_UserException,
                  (::CORBA::CompletionStatus)s.completion());
  }
}

// Local call call-back function.
static void
_0RL_lcfn_6fe2f94a21a10053_24000000(omniCallDescriptor* cd, omniServant* svnt)
{
  _0RL_cd_6fe2f94a21a10053_14000000* tcd = (_0RL_cd_6fe2f94a21a10053_14000000*)cd;
  Tango::_impl_Device_4* impl = (Tango::_impl_Device_4*) svnt->_ptrToInterface(Tango::Device_4::_PD_repoId);
#ifdef HAS_Cplusplus_catch_exception_by_base
  tcd->result = impl->write_read_attributes_4(*tcd->arg_0, *tcd->arg_1);
#else
  if (!cd->is_upcall())
    tcd->result = impl->write_read_attributes_4(*tcd->arg_0, *tcd->arg_1);
  else {
    try {
      tcd->result = impl->write_read_attributes_4(*tcd->arg_0, *tcd->arg_1);
    }
    catch(Tango::DevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }

    catch(Tango::MultiDevFailed& ex) {
      throw omniORB::StubUserException(ex._NP_duplicate());
    }


  }
#endif


}

Tango::AttributeValueList_4* Tango::_objref_Device_4::write_read_attributes_4(const ::Tango::AttributeValueList_4& values, const ::Tango::ClntIdent& cl_ident)
{
  _0RL_cd_6fe2f94a21a10053_14000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_24000000, "write_read_attributes_4", 24);
  _call_desc.arg_0 = &(::Tango::AttributeValueList_4&) values;
  _call_desc.arg_1 = &(::Tango::ClntIdent&) cl_ident;

  _invoke(_call_desc);
  return _call_desc.result._retn();


}
Tango::_pof_Device_4::~_pof_Device_4() {}


omniObjRef*
Tango::_pof_Device_4::newObjRef(omniIOR* ior, omniIdentity* id)
{
  return new ::Tango::_objref_Device_4(ior, id);
}


::CORBA::Boolean
Tango::_pof_Device_4::is_a(const char* id) const
{
  if( omni::ptrStrMatch(id, ::Tango::Device_4::_PD_repoId) )
    return 1;
  if( omni::ptrStrMatch(id, Tango::Device_3::_PD_repoId) )
    return 1;

  if( omni::ptrStrMatch(id, Tango::Device_2::_PD_repoId) )
    return 1;

  if( omni::ptrStrMatch(id, Tango::Device::_PD_repoId) )
    return 1;


  return 0;
}

const Tango::_pof_Device_4 _the_pof_Tango_mDevice__4;

Tango::_impl_Device_4::~_impl_Device_4() {}


::CORBA::Boolean
Tango::_impl_Device_4::_dispatch(omniCallHandle& _handle)
{
  const char* op = _handle.operation_name();

  if( omni::strMatch(op, "read_attribute_history_4") ) {

    _0RL_cd_6fe2f94a21a10053_53000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_63000000, "read_attribute_history_4", 25, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "command_inout_history_4") ) {

    _0RL_cd_6fe2f94a21a10053_73000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_83000000, "command_inout_history_4", 24, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "command_inout_4") ) {

    _0RL_cd_6fe2f94a21a10053_93000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_a3000000, "command_inout_4", 16, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "read_attributes_4") ) {

    _0RL_cd_6fe2f94a21a10053_b3000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_c3000000, "read_attributes_4", 18, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "write_attributes_4") ) {

    _0RL_cd_6fe2f94a21a10053_d3000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_e3000000, "write_attributes_4", 19, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "set_attribute_config_4") ) {

    _0RL_cd_6fe2f94a21a10053_f3000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_04000000, "set_attribute_config_4", 23, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  if( omni::strMatch(op, "write_read_attributes_4") ) {

    _0RL_cd_6fe2f94a21a10053_14000000 _call_desc(_0RL_lcfn_6fe2f94a21a10053_24000000, "write_read_attributes_4", 24, 1);
    
    _handle.upcall(this,_call_desc);
    return 1;
  }

  
#ifndef _MSC_VER
  if( _impl_Device_3::_dispatch(_handle) ) {
    return 1;
  }
#else
  // Work-around for incorrect MSVC code generation.
  if( ((_impl_Device_3*)this)->
      _impl_Device_3::_dispatch(_handle) ) {
    return 1;
  }
#endif


  return 0;
}

void*
Tango::_impl_Device_4::_ptrToInterface(const char* id)
{
  if( id == ::Tango::Device_4::_PD_repoId )
    return (::Tango::_impl_Device_4*) this;
  if( id == ::Tango::Device_3::_PD_repoId )
    return (::Tango::_impl_Device_3*) this;

  if( id == ::Tango::Device_2::_PD_repoId )
    return (::Tango::_impl_Device_2*) this;

  if( id == ::Tango::Device::_PD_repoId )
    return (::Tango::_impl_Device*) this;


  if( id == ::CORBA::Object::_PD_repoId )
    return (void*) 1;

  if( omni::strMatch(id, ::Tango::Device_4::_PD_repoId) )
    return (::Tango::_impl_Device_4*) this;
  if( omni::strMatch(id, ::Tango::Device_3::_PD_repoId) )
    return (::Tango::_impl_Device_3*) this;

  if( omni::strMatch(id, ::Tango::Device_2::_PD_repoId) )
    return (::Tango::_impl_Device_2*) this;

  if( omni::strMatch(id, ::Tango::Device::_PD_repoId) )
    return (::Tango::_impl_Device*) this;


  if( omni::strMatch(id, ::CORBA::Object::_PD_repoId) )
    return (void*) 1;
  return 0;
}

const char*
Tango::_impl_Device_4::_mostDerivedRepoId()
{
  return ::Tango::Device_4::_PD_repoId;
}

POA_Tango::Device::~Device() {}

POA_Tango::Device_2::~Device_2() {}

POA_Tango::Device_3::~Device_3() {}

POA_Tango::Device_4::~Device_4() {}

