#include <stdio.h>
#include <string.h>
#include <error.h>

#include "main.h"
#include "gettext.h"

int par_popsize=POPSIZE_DEF;
int par_toursize=TOURSIZE_DEF;
int par_mutatepart=MUTATEPART_DEF;
int par_randpart=RANDPART_DEF;
int par_maxequal=MAXEQUAL_DEF;
int par_finish=FINISH_DEF;
int par_migrtime=MIGRTIME_DEF;
int par_migrpart=MIGRPART_DEF;
int par_localtresh=LOCALTRESH_DEF;

struct {
	char *name;
	int *value;
} par_lookup[] = { 	{ "popsize", &par_popsize },
			{ "toursize", &par_toursize },
			{ "mutatepart", &par_mutatepart },
			{ "randpart", &par_randpart }, 
			{ "maxequal", &par_maxequal },
			{ "finish", &par_finish }, 
			{ "migrtime", &par_migrtime },
			{ "migrpart", &par_migrpart },
			{ "localtresh", &par_localtresh },
			{ NULL, NULL } };

/* return 0 in case of syntax error */
int get_params(char *i) 
{
	char name[256];
	char value[256];
	int value1;

	int n,m;

	n=0;

	while(1) {
		if(i[n]==0) return 1;
		if(i[n]==',') n++;

		m=0;
		while(i[n]!=0&&i[n]!='=') name[m++]=i[n++];
		name[m]=0;
		if(i[n]==0) return 0;

		m=0;
		n++;
		while(i[n]!=0&&i[n]!=',') value[m++]=i[n++];
		value[m]=0;

		m=sscanf(value, "%d", &value1);
		if(m<1) return 0;

		m=0;
		while(par_lookup[m].name!=NULL&&strcmp(par_lookup[m].name,name)) m++;
			
		if(par_lookup[m].name!=NULL) {
			*par_lookup[m].value=value1;
		} else {
			return 0;
		}
	}
}

void print_params()
{
	int m;

	debug(_("Genetic parameters:"));
	m=0;
	while(par_lookup[m].name!=NULL) {
		debug(_("%s=%d"), par_lookup[m].name, *par_lookup[m].value);
		m++;
	}
}
