/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2004 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: counter.c,v 1.6 2004/09/24 13:57:03 avian Exp $ */

#include <stdio.h>
#include <sys/time.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gettext.h"

/* internal (don't touch these from outside) */
static struct timeval cnt_start;
static int cnt_last;
static int cnt_gens;
static int cnt_on;

/* external (set from outside before counter_init) */
int cnt_stopped;
int cnt_recv;
int cnt_total;
int cnt_newline;

void counter_init()
{
	gettimeofday(&cnt_start, NULL);
	cnt_gens=0;
	cnt_on=0;
	cnt_last=0;
}

void counter_update(int sender, int grade, int mandatory, int gens)
{
	float gpm;
	struct timeval now;
	int s;

	cnt_gens++;
	gettimeofday(&now, NULL);

	if(!(now.tv_sec-cnt_last)) return;

	cnt_on=1;

	s=now.tv_sec-cnt_start.tv_sec;
	gpm=((float) cnt_gens*60)/s;

        printf(_("[%x] reports %d (%d) at %d"), sender, grade, mandatory, gens);
	printf(_(", %.1f GPM"), gpm);
	printf(_(", %02d:%02d:%02d elapsed"), s/3600, (s/60)%60, s%60);
	printf(_(", %d/%d running "), cnt_total-cnt_stopped, cnt_total);
	printf("%c", cnt_newline?'\n':'\r');
	fflush(stdout);
	cnt_last=now.tv_sec;
}

void counter_clear()
{
	int n;
	if(cnt_on&&(!cnt_newline)) {
		for(n=0;n<80;n++) printf(" ");
		printf("\r");
		fflush(stdout);
		cnt_on=0;
	}
}
